/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;

public final class PrimitiveTypeUtil {
    private PrimitiveTypeUtil() {
    }

    public static Type getPrimitiveTypeFromDescriptor(String descriptor) {
        int dimension = 0;
        while (descriptor.charAt(dimension) == '[') {
            ++dimension;
        }
        if (dimension == 0) {
            return PrimitiveType.getPrimitiveType(descriptor.charAt(dimension));
        }
        return new ObjectType(descriptor.substring(dimension), dimension);
    }

    public static PrimitiveType getPrimitiveTypeFromValue(int value) {
        if (value >= 0) {
            if (value <= 1) {
                return PrimitiveType.MAYBE_BOOLEAN_TYPE;
            }
            if (value <= 127) {
                return PrimitiveType.MAYBE_BYTE_TYPE;
            }
            if (value <= Short.MAX_VALUE) {
                return PrimitiveType.MAYBE_SHORT_TYPE;
            }
            if (value <= 65535) {
                return PrimitiveType.MAYBE_CHAR_TYPE;
            }
        } else {
            if (value >= -128) {
                return PrimitiveType.MAYBE_NEGATIVE_BYTE_TYPE;
            }
            if (value >= Short.MIN_VALUE) {
                return PrimitiveType.MAYBE_NEGATIVE_SHORT_TYPE;
            }
        }
        return PrimitiveType.MAYBE_INT_TYPE;
    }

    public static PrimitiveType getCommonPrimitiveType(PrimitiveType pt1, PrimitiveType pt2) {
        return PrimitiveTypeUtil.getPrimitiveTypeFromFlags(pt1.getFlags() & pt2.getFlags());
    }

    public static PrimitiveType getPrimitiveTypeFromFlags(int flags) {
        return switch (flags) {
            case 1 -> PrimitiveType.TYPE_BOOLEAN;
            case 2 -> PrimitiveType.TYPE_CHAR;
            case 4 -> PrimitiveType.TYPE_FLOAT;
            case 8 -> PrimitiveType.TYPE_DOUBLE;
            case 16 -> PrimitiveType.TYPE_BYTE;
            case 32 -> PrimitiveType.TYPE_SHORT;
            case 64 -> PrimitiveType.TYPE_INT;
            case 128 -> PrimitiveType.TYPE_LONG;
            case 256 -> PrimitiveType.TYPE_VOID;
            default -> {
                switch (flags) {
                    case 66: {
                        yield PrimitiveType.MAYBE_CHAR_TYPE;
                    }
                    case 98: {
                        yield PrimitiveType.MAYBE_SHORT_TYPE;
                    }
                    case 114: {
                        yield PrimitiveType.MAYBE_BYTE_TYPE;
                    }
                    case 115: {
                        yield PrimitiveType.MAYBE_BOOLEAN_TYPE;
                    }
                    case 112: {
                        yield PrimitiveType.MAYBE_NEGATIVE_BYTE_TYPE;
                    }
                    case 96: {
                        yield PrimitiveType.MAYBE_NEGATIVE_SHORT_TYPE;
                    }
                    case 113: {
                        yield PrimitiveType.MAYBE_NEGATIVE_BOOLEAN_TYPE;
                    }
                }
                yield null;
            }
        };
    }

    public static Type getPrimitiveTypeFromTag(int tag) {
        return switch (tag) {
            case 4 -> PrimitiveType.TYPE_BOOLEAN;
            case 5 -> PrimitiveType.TYPE_CHAR;
            case 6 -> PrimitiveType.TYPE_FLOAT;
            case 7 -> PrimitiveType.TYPE_DOUBLE;
            case 8 -> PrimitiveType.TYPE_BYTE;
            case 9 -> PrimitiveType.TYPE_SHORT;
            case 10 -> PrimitiveType.TYPE_INT;
            case 11 -> PrimitiveType.TYPE_LONG;
            default -> throw new IllegalStateException();
        };
    }
}

