/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.type;

import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class PrimitiveType
implements Type {
    public static final int FLAG_BOOLEAN = 1;
    public static final int FLAG_CHAR = 2;
    public static final int FLAG_FLOAT = 4;
    public static final int FLAG_DOUBLE = 8;
    public static final int FLAG_BYTE = 16;
    public static final int FLAG_SHORT = 32;
    public static final int FLAG_INT = 64;
    public static final int FLAG_LONG = 128;
    public static final int FLAG_VOID = 256;
    public static final PrimitiveType TYPE_BOOLEAN = new PrimitiveType("boolean", 1, 1, 1);
    public static final PrimitiveType TYPE_BYTE = new PrimitiveType("byte", 16, 16, 112);
    public static final PrimitiveType TYPE_CHAR = new PrimitiveType("char", 2, 2, 66);
    public static final PrimitiveType TYPE_DOUBLE = new PrimitiveType("double", 8, 8, 8);
    public static final PrimitiveType TYPE_FLOAT = new PrimitiveType("float", 4, 4, 4);
    public static final PrimitiveType TYPE_INT = new PrimitiveType("int", 64, 114, 64);
    public static final PrimitiveType TYPE_LONG = new PrimitiveType("long", 128, 128, 128);
    public static final PrimitiveType TYPE_SHORT = new PrimitiveType("short", 32, 48, 96);
    public static final PrimitiveType TYPE_VOID = new PrimitiveType("void", 256, 256, 256);
    public static final PrimitiveType MAYBE_CHAR_TYPE = new PrimitiveType("maybe_char", 66, 66, 66);
    public static final PrimitiveType MAYBE_SHORT_TYPE = new PrimitiveType("maybe_short", 98, 98, 98);
    public static final PrimitiveType MAYBE_BYTE_TYPE = new PrimitiveType("maybe_byte", 114, 114, 114);
    public static final PrimitiveType MAYBE_BOOLEAN_TYPE = new PrimitiveType("maybe_boolean", 115, 115, 115);
    public static final PrimitiveType MAYBE_NEGATIVE_BYTE_TYPE = new PrimitiveType("maybe_negative_byte", 112, 112, 112);
    public static final PrimitiveType MAYBE_NEGATIVE_SHORT_TYPE = new PrimitiveType("maybe_negative_short", 96, 96, 96);
    public static final PrimitiveType MAYBE_INT_TYPE = new PrimitiveType("maybe_int", 64, 64, 64);
    public static final PrimitiveType MAYBE_NEGATIVE_BOOLEAN_TYPE = new PrimitiveType("maybe_negative_boolean", 113, 113, 113);
    protected static final PrimitiveType[] descriptorToType = new PrimitiveType[25];
    private final String name;
    private final int flags;
    private final int leftFlags;
    private final int rightFlags;
    private final String descriptor;

    protected PrimitiveType(String name, int flags, int leftFlags, int rightFlags) {
        this.name = name;
        this.flags = flags;
        this.leftFlags = leftFlags;
        this.rightFlags = rightFlags;
        StringBuilder sb = new StringBuilder();
        if ((flags & 8) != 0) {
            sb.append('D');
        } else if ((flags & 4) != 0) {
            sb.append('F');
        } else if ((flags & 0x80) != 0) {
            sb.append('J');
        } else if ((flags & 1) != 0) {
            sb.append('Z');
        } else if ((flags & 0x10) != 0) {
            sb.append('B');
        } else if ((flags & 2) != 0) {
            sb.append('C');
        } else if ((flags & 0x20) != 0) {
            sb.append('S');
        } else {
            sb.append('I');
        }
        this.descriptor = sb.toString();
    }

    public static PrimitiveType getPrimitiveType(char primitiveDescriptor) {
        return descriptorToType[primitiveDescriptor - 66];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getLeftFlags() {
        return this.leftFlags;
    }

    public int getRightFlags() {
        return this.rightFlags;
    }

    @Override
    public Type createType(int dimension) {
        if (dimension < 0) {
            throw new IllegalArgumentException("PrimitiveType.createType(dim) : create type with negative dimension");
        }
        if (dimension == 0) {
            return this;
        }
        return new ObjectType(this.descriptor, dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveType that = (PrimitiveType)o;
        return this.flags == that.flags;
    }

    public int hashCode() {
        return 750039781 + this.flags;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(TypeArgumentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isTypeArgumentAssignableFrom(TypeMaker typeMaker, Map<String, TypeArgument> typeBindings, Map<String, BaseType> typeBounds, BaseTypeArgument typeArgument) {
        return this.equals(typeArgument);
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    @Override
    public boolean isPrimitiveTypeArgument() {
        return true;
    }

    public String toString() {
        return "PrimitiveType{primitive=" + this.name + "}";
    }

    public int getJavaPrimitiveFlags() {
        if ((this.flags & 1) != 0) {
            return 1;
        }
        if ((this.flags & 0x40) != 0) {
            return 64;
        }
        if ((this.flags & 2) != 0) {
            return 2;
        }
        if ((this.flags & 0x20) != 0) {
            return 32;
        }
        if ((this.flags & 0x10) != 0) {
            return 16;
        }
        return this.flags;
    }

    static {
        PrimitiveType.descriptorToType[0] = TYPE_BYTE;
        PrimitiveType.descriptorToType[1] = TYPE_CHAR;
        PrimitiveType.descriptorToType[2] = TYPE_DOUBLE;
        PrimitiveType.descriptorToType[4] = TYPE_FLOAT;
        PrimitiveType.descriptorToType[7] = TYPE_INT;
        PrimitiveType.descriptorToType[8] = TYPE_LONG;
        PrimitiveType.descriptorToType[17] = TYPE_SHORT;
        PrimitiveType.descriptorToType[20] = TYPE_VOID;
        PrimitiveType.descriptorToType[24] = TYPE_BOOLEAN;
    }
}

