/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.type;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class ObjectType
implements Type {
    public static final ObjectType TYPE_BOOLEAN = new ObjectType("java/lang/Boolean", "java.lang.Boolean", "Boolean");
    public static final ObjectType TYPE_BYTE = new ObjectType("java/lang/Byte", "java.lang.Byte", "Byte");
    public static final ObjectType TYPE_CHARACTER = new ObjectType("java/lang/Character", "java.lang.Character", "Character");
    public static final ObjectType TYPE_CLASS = new ObjectType("java/lang/Class", "java.lang.Class", "Class");
    public static final ObjectType TYPE_CLASS_WILDCARD = TYPE_CLASS.createType(WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT);
    public static final ObjectType TYPE_DATE = new ObjectType("java/util/Date", "java.util.Date", "Date");
    public static final ObjectType TYPE_DOUBLE = new ObjectType("java/lang/Double", "java.lang.Double", "Double");
    public static final ObjectType TYPE_ENUM = new ObjectType("java/lang/Enum", "java.lang.Enum", "Enum");
    public static final ObjectType TYPE_EXCEPTION = new ObjectType("java/lang/Exception", "java.lang.Exception", "Exception");
    public static final ObjectType TYPE_FLOAT = new ObjectType("java/lang/Float", "java.lang.Float", "Float");
    public static final ObjectType TYPE_INTEGER = new ObjectType("java/lang/Integer", "java.lang.Integer", "Integer");
    public static final ObjectType TYPE_ITERABLE = new ObjectType("java/lang/Iterable", "java.lang.Iterable", "Iterable");
    public static final ObjectType TYPE_LONG = new ObjectType("java/lang/Long", "java.lang.Long", "Long");
    public static final ObjectType TYPE_MATH = new ObjectType("java/lang/Math", "java.lang.Math", "Math");
    public static final ObjectType TYPE_NUMBER = new ObjectType("java/lang/Number", "java.lang.Number", "Number");
    public static final ObjectType TYPE_OBJECT = new ObjectType("java/lang/Object", "java.lang.Object", "Object");
    public static final ObjectType TYPE_RUNTIME_EXCEPTION = new ObjectType("java/lang/RuntimeException", "java.lang.RuntimeException", "RuntimeException");
    public static final ObjectType TYPE_SHORT = new ObjectType("java/lang/Short", "java.lang.Short", "Short");
    public static final ObjectType TYPE_STRING = new ObjectType("java/lang/String", "java.lang.String", "String");
    public static final ObjectType TYPE_STRING_BUFFER = new ObjectType("java/lang/StringBuffer", "java.lang.StringBuffer", "StringBuffer");
    public static final ObjectType TYPE_STRING_BUILDER = new ObjectType("java/lang/StringBuilder", "java.lang.StringBuilder", "StringBuilder");
    public static final ObjectType TYPE_SYSTEM = new ObjectType("java/lang/System", "java.lang.System", "System");
    public static final ObjectType TYPE_THREAD = new ObjectType("java/lang/Thread", "java.lang.Thread", "Thread");
    public static final ObjectType TYPE_THROWABLE = new ObjectType("java/lang/Throwable", "java.lang.Throwable", "Throwable");
    public static final ObjectType TYPE_PRIMITIVE_BOOLEAN = new ObjectType("Z");
    public static final ObjectType TYPE_PRIMITIVE_BYTE = new ObjectType("B");
    public static final ObjectType TYPE_PRIMITIVE_CHAR = new ObjectType("C");
    public static final ObjectType TYPE_PRIMITIVE_DOUBLE = new ObjectType("D");
    public static final ObjectType TYPE_PRIMITIVE_FLOAT = new ObjectType("F");
    public static final ObjectType TYPE_PRIMITIVE_INT = new ObjectType("I");
    public static final ObjectType TYPE_PRIMITIVE_LONG = new ObjectType("J");
    public static final ObjectType TYPE_PRIMITIVE_SHORT = new ObjectType("S");
    public static final ObjectType TYPE_PRIMITIVE_VOID = new ObjectType("V");
    public static final ObjectType TYPE_UNDEFINED_OBJECT = new ObjectType("java/lang/Object", "java.lang.Object", "Object"){

        @Override
        public String toString() {
            return "UndefinedObjectType";
        }
    };
    protected final String internalName;
    protected final String qualifiedName;
    protected final String name;
    protected final BaseTypeArgument typeArguments;
    protected final int dimension;
    protected final String descriptor;
    protected final Set<String> innerTypeNames;

    public ObjectType(String internalName, String qualifiedName, String name, Set<String> innerTypeNames) {
        this(internalName, qualifiedName, name, innerTypeNames, null, 0);
    }

    public ObjectType(String internalName, String qualifiedName, String name, Set<String> innerTypeNames, int dimension) {
        this(internalName, qualifiedName, name, innerTypeNames, null, dimension);
    }

    public ObjectType(String internalName, String qualifiedName, String name, Set<String> innerTypeNames, BaseTypeArgument typeArguments) {
        this(internalName, qualifiedName, name, innerTypeNames, typeArguments, 0);
    }

    public ObjectType(String internalName, String qualifiedName, String name) {
        this(internalName, qualifiedName, name, Collections.emptySet(), null, 0);
    }

    public ObjectType(String internalName, String qualifiedName, String name, int dimension) {
        this(internalName, qualifiedName, name, Collections.emptySet(), null, dimension);
    }

    public ObjectType(String internalName, String qualifiedName, String name, BaseTypeArgument typeArguments) {
        this(internalName, qualifiedName, name, Collections.emptySet(), typeArguments, 0);
    }

    public ObjectType(String internalName, String qualifiedName, String name, BaseTypeArgument typeArguments, int dimension) {
        this(internalName, qualifiedName, name, Collections.emptySet(), typeArguments, dimension);
    }

    public ObjectType(String internalName, String qualifiedName, String name, Set<String> innerTypeNames, BaseTypeArgument typeArguments, int dimension) {
        this.internalName = internalName;
        this.qualifiedName = qualifiedName;
        this.name = name;
        this.typeArguments = typeArguments;
        this.dimension = dimension;
        this.descriptor = ObjectType.createDescriptor("L" + internalName + ";", dimension);
        this.innerTypeNames = innerTypeNames;
        if (internalName == null || internalName.endsWith(";")) {
            throw new IllegalArgumentException("internal name is null or ends with ;");
        }
    }

    public ObjectType(String primitiveDescriptor) {
        this(primitiveDescriptor, 0);
    }

    public ObjectType(String primitiveDescriptor, int dimension) {
        this.internalName = primitiveDescriptor;
        this.qualifiedName = this.name = PrimitiveType.getPrimitiveType(primitiveDescriptor.charAt(0)).getName();
        this.dimension = dimension;
        this.descriptor = ObjectType.createDescriptor(primitiveDescriptor, dimension);
        this.typeArguments = null;
        this.innerTypeNames = Collections.emptySet();
    }

    protected static String createDescriptor(String descriptor, int dimension) {
        return switch (dimension) {
            case 0 -> descriptor;
            case 1 -> "[" + descriptor;
            case 2 -> "[[" + descriptor;
            default -> new String(new char[dimension]).replace('\u0000', '[') + descriptor;
        };
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BaseTypeArgument getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public Type createType(int dimension) {
        if (dimension < 0) {
            throw new IllegalArgumentException("ObjectType.createType(dim) : create type with negative dimension");
        }
        if (this.dimension == dimension) {
            return this;
        }
        if (this.descriptor.charAt(this.descriptor.length() - 1) == ';') {
            return new ObjectType(this.internalName, this.qualifiedName, this.name, this.typeArguments, dimension);
        }
        if (dimension == 0) {
            return PrimitiveType.getPrimitiveType(this.descriptor.charAt(this.dimension));
        }
        return new ObjectType(this.internalName, dimension);
    }

    public ObjectType createType(BaseTypeArgument typeArguments) {
        if (this.typeArguments == typeArguments) {
            return this;
        }
        return new ObjectType(this.internalName, this.qualifiedName, this.name, typeArguments, this.dimension);
    }

    public boolean rawEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        return this.dimension == that.dimension && this.internalName.equals(that.internalName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        if (this.dimension != that.dimension || !this.internalName.equals(that.internalName)) {
            return false;
        }
        if ("java/lang/Class".equals(this.internalName)) {
            boolean wildcard2;
            boolean wildcard1 = this.typeArguments == null || this.typeArguments.isWildcardTypeArgument();
            boolean bl = wildcard2 = that.typeArguments == null || that.typeArguments.isWildcardTypeArgument();
            if (wildcard1 && wildcard2) {
                return true;
            }
        }
        return Objects.equals(this.typeArguments, that.typeArguments);
    }

    public int hashCode() {
        int result = 735485092 + this.internalName.hashCode();
        result = 31 * result + Objects.hash(this.typeArguments);
        return 31 * result + this.dimension;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(TypeArgumentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isTypeArgumentAssignableFrom(TypeMaker typeMaker, Map<String, TypeArgument> typeBindings, Map<String, BaseType> typeBounds, BaseTypeArgument typeArgument) {
        GenericType gt;
        BaseType bt;
        if (typeArgument instanceof ObjectType || typeArgument instanceof InnerObjectType) {
            ObjectType ot = (ObjectType)typeArgument;
            if (this.dimension != ot.getDimension() || !this.internalName.equals(ot.getInternalName())) {
                return false;
            }
            if (ot.getTypeArguments() == null) {
                return this.typeArguments == null;
            }
            if (this.typeArguments == null) {
                return ot.getTypeArguments() == null;
            }
            return this.typeArguments.isTypeArgumentAssignableFrom(typeMaker, typeBindings, typeBounds, ot.getTypeArguments());
        }
        if (typeArgument instanceof GenericType && (bt = typeBounds.get((gt = (GenericType)typeArgument).getName())) != null) {
            for (Type type : bt) {
                ObjectType ot;
                if (this.dimension != type.getDimension() || !(type instanceof ObjectType) && !(type instanceof InnerObjectType) || !this.internalName.equals((ot = (ObjectType)type).getInternalName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isObjectType() {
        return true;
    }

    @Override
    public boolean isObjectTypeArgument() {
        return true;
    }

    public Set<String> getInnerTypeNames() {
        return this.innerTypeNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ObjectType{");
        sb.append(this.internalName);
        if (this.typeArguments != null) {
            sb.append('<').append(this.typeArguments).append('>');
        }
        if (this.dimension > 0) {
            sb.append(", dimension=").append(this.dimension);
        }
        return sb.append('}').toString();
    }
}

