/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.type;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;

public class InnerObjectType
extends ObjectType {
    private ObjectType outerType;

    public InnerObjectType(String internalName, String qualifiedName, String name, Set<String> innerTypeNames, ObjectType outerType) {
        super(internalName, qualifiedName, name, innerTypeNames);
        this.setOuterType(outerType);
        this.checkArguments(qualifiedName, name);
    }

    public InnerObjectType(String internalName, String qualifiedName, String name, Set<String> innerTypeNames, BaseTypeArgument typeArguments, int dimension, ObjectType outerType) {
        super(internalName, qualifiedName, name, innerTypeNames, typeArguments, dimension);
        this.setOuterType(outerType);
        this.checkArguments(qualifiedName, name);
    }

    public InnerObjectType(String internalName, String qualifiedName, String name, ObjectType outerType) {
        super(internalName, qualifiedName, name, Collections.emptySet());
        this.setOuterType(outerType);
        this.checkArguments(qualifiedName, name);
    }

    public InnerObjectType(String internalName, String qualifiedName, String name, BaseTypeArgument typeArguments, ObjectType outerType) {
        super(internalName, qualifiedName, name, Collections.emptySet(), typeArguments);
        this.setOuterType(outerType);
        this.checkArguments(qualifiedName, name);
    }

    public InnerObjectType(String internalName, String qualifiedName, String name, BaseTypeArgument typeArguments, int dimension, ObjectType outerType) {
        super(internalName, qualifiedName, name, Collections.emptySet(), typeArguments, dimension);
        this.outerType = outerType;
        this.checkArguments(qualifiedName, name);
    }

    protected void checkArguments(String qualifiedName, String name) {
        if (name != null && Character.isDigit(name.charAt(0)) && qualifiedName != null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public ObjectType getOuterType() {
        return this.outerType;
    }

    public void setOuterType(ObjectType outerType) {
        this.outerType = outerType;
    }

    @Override
    public Type createType(int dimension) {
        if (dimension < 0) {
            throw new IllegalArgumentException("InnerObjectType.createType(dim) : create type with negative dimension");
        }
        return new InnerObjectType(this.internalName, this.qualifiedName, this.name, this.innerTypeNames, this.typeArguments, dimension, this.outerType);
    }

    @Override
    public ObjectType createType(BaseTypeArgument typeArguments) {
        return new InnerObjectType(this.internalName, this.qualifiedName, this.name, this.innerTypeNames, typeArguments, this.dimension, this.outerType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        InnerObjectType that = (InnerObjectType)o;
        return Objects.equals(this.outerType, that.outerType);
    }

    @Override
    public int hashCode() {
        int result = 111476860 + super.hashCode();
        return 31 * result + Objects.hashCode(this.outerType);
    }

    @Override
    public boolean isInnerObjectType() {
        return true;
    }

    @Override
    public boolean isInnerObjectTypeArgument() {
        return true;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(TypeArgumentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        if (this.typeArguments == null) {
            return "InnerObjectType{" + this.outerType + "." + this.descriptor + "}";
        }
        return "InnerObjectType{" + this.outerType + "." + this.descriptor + "<" + this.typeArguments + ">}";
    }
}

