/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.type;

import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class GenericType
implements Type {
    private final String name;
    private final int dimension;

    public GenericType(String name) {
        this.name = name;
        this.dimension = 0;
    }

    public GenericType(String name, int dimension) {
        this.name = name;
        this.dimension = dimension;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescriptor() {
        return this.name;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public Type createType(int dimension) {
        if (dimension < 0) {
            throw new IllegalArgumentException("GenericType.createType(dim) : create type with negative dimension");
        }
        if (this.dimension == dimension) {
            return this;
        }
        return new GenericType(this.name, dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericType that = (GenericType)o;
        return this.dimension == that.dimension && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = 991890290 + this.name.hashCode();
        return 31 * result + this.dimension;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(TypeArgumentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isTypeArgumentAssignableFrom(TypeMaker typeMaker, Map<String, TypeArgument> typeBindings, Map<String, BaseType> typeBounds, BaseTypeArgument typeArgument) {
        GenericType genericType;
        BaseType boundType;
        TypeArgument boundType2;
        if (typeBindings != null && (boundType2 = typeBindings.get(this.name)) != null) {
            if (typeArgument instanceof WildcardExtendsTypeArgument) {
                WildcardExtendsTypeArgument wildcardExtendsTypeArgument = (WildcardExtendsTypeArgument)typeArgument;
                return wildcardExtendsTypeArgument.type().equals(boundType2);
            }
            return boundType2.equals(typeArgument);
        }
        if (typeArgument instanceof GenericType && (boundType = typeBounds.get((genericType = (GenericType)typeArgument).getName())) != null && this.equals(boundType)) {
            return true;
        }
        return this.equals(typeArgument);
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public boolean isGenericTypeArgument() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GenericType{");
        sb.append(this.name);
        if (this.dimension > 0) {
            sb.append(", dimension=").append(this.dimension);
        }
        return sb.append('}').toString();
    }
}

