/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.statement;

import java.util.Objects;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;

public class ReturnExpressionStatement
implements Statement {
    private int lineNumber;
    private Expression expression;

    public ReturnExpressionStatement(Expression expression) {
        this(expression.getLineNumber(), expression);
    }

    public ReturnExpressionStatement(int lineNumber, Expression expression) {
        this.lineNumber = lineNumber;
        this.expression = expression;
        Objects.requireNonNull(expression);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        Objects.requireNonNull(expression);
        this.expression = expression;
    }

    public <T extends Expression> T getGenericExpression() {
        return (T)this.expression;
    }

    @Override
    public boolean isReturnExpressionStatement() {
        return true;
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "ReturnExpressionStatement{return " + this.expression + "}";
    }
}

