/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;

public class TypeReferenceDotClassExpression
implements Expression {
    private final int lineNumber;
    private final Type typeDotClass;
    private final Type type;

    public TypeReferenceDotClassExpression(Type typeDotClass) {
        this(0, typeDotClass);
    }

    public TypeReferenceDotClassExpression(int lineNumber, Type typeDotClass) {
        this.lineNumber = lineNumber;
        this.typeDotClass = typeDotClass;
        this.type = ObjectType.TYPE_CLASS.createType(typeDotClass);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public Type getTypeDotClass() {
        return this.typeDotClass;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "TypeReferenceDotClassExpression{" + this.typeDotClass + "}";
    }

    @Override
    public Expression copyTo(int lineNumber) {
        return new TypeReferenceDotClassExpression(lineNumber, this.typeDotClass);
    }
}

