/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.Type;

public class PreOperatorExpression
extends AbstractLineNumberExpression {
    private final String operator;
    private Expression expression;

    public PreOperatorExpression(int lineNumber, String operator, Expression expression) {
        super(lineNumber);
        this.operator = operator;
        this.setExpression(expression);
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public Type getType() {
        return this.expression.getType();
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public boolean isPreOperatorExpression() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "PreOperatorExpression{" + this.operator + " " + this.expression + "}";
    }

    @Override
    public Expression copyTo(int lineNumber) {
        return new PreOperatorExpression(lineNumber, this.operator, this.expression);
    }
}

