/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;

public class NewExpression
extends AbstractLineNumberExpression {
    protected ObjectType type;
    protected String descriptor;
    protected BaseExpression parameters;
    private final BodyDeclaration bodyDeclaration;
    private boolean diamondPossible;
    private Expression qualifier;
    private final boolean varArgs;

    public NewExpression(int lineNumber, ObjectType type, String descriptor, boolean varArgs, boolean diamondPossible) {
        this(lineNumber, type, descriptor, null, varArgs, diamondPossible);
    }

    public NewExpression(int lineNumber, ObjectType type, String descriptor, BodyDeclaration bodyDeclaration, boolean varArgs, boolean diamondPossible) {
        super(lineNumber);
        this.setType(type);
        this.descriptor = descriptor;
        this.bodyDeclaration = bodyDeclaration;
        this.diamondPossible = diamondPossible;
        this.varArgs = varArgs;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    @Override
    public ObjectType getObjectType() {
        return this.type;
    }

    public void setObjectType(ObjectType type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setType(ObjectType type) {
        this.setObjectType(type);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public BaseExpression getParameters() {
        return this.parameters;
    }

    public void setParameters(BaseExpression parameters) {
        this.parameters = parameters;
    }

    public BodyDeclaration getBodyDeclaration() {
        return this.bodyDeclaration;
    }

    public boolean isDiamondPossible() {
        return this.diamondPossible;
    }

    public void setDiamondPossible(boolean diamondPossible) {
        this.diamondPossible = diamondPossible;
    }

    public Expression getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Expression qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public boolean isNewExpression() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "NewExpression{new " + this.type + "}";
    }

    @Override
    public Expression copyTo(int lineNumber) {
        return new NewExpression(lineNumber, this.type, this.descriptor, this.bodyDeclaration, this.varArgs, this.diamondPossible);
    }
}

