/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import java.util.Map;
import java.util.Optional;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.MethodReferenceExpression;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class MethodInvocationExpression
extends MethodReferenceExpression {
    private BaseTypeArgument nonWildcardTypeArguments;
    private BaseExpression parameters;
    private final TypeMaker.MethodTypes methodTypes;
    private Map<String, BaseType> typeBounds;
    private Map<String, TypeArgument> typeBindings;

    public MethodInvocationExpression(Type type, Expression expression, String internalTypeName, String name, String descriptor, TypeMaker.MethodTypes methodTypes) {
        this(type, expression, internalTypeName, name, descriptor, null, methodTypes);
    }

    public MethodInvocationExpression(Type type, Expression expression, String internalTypeName, String name, String descriptor, BaseExpression parameters, TypeMaker.MethodTypes methodTypes) {
        this(0, type, expression, internalTypeName, name, descriptor, parameters, methodTypes);
    }

    public MethodInvocationExpression(int lineNumber, Type type, Expression expression, String internalTypeName, String name, String descriptor, BaseExpression parameters, TypeMaker.MethodTypes methodTypes) {
        super(lineNumber, type, expression, internalTypeName, name, descriptor);
        this.parameters = parameters;
        this.methodTypes = methodTypes;
    }

    public boolean isVarArgs() {
        return Optional.ofNullable(this.methodTypes).map(TypeMaker.MethodTypes::isVarArgs).orElse(false);
    }

    public BaseType getExceptionTypes() {
        return Optional.ofNullable(this.methodTypes).map(TypeMaker.MethodTypes::getExceptionTypes).orElse(null);
    }

    public BaseTypeArgument getNonWildcardTypeArguments() {
        return this.nonWildcardTypeArguments;
    }

    public void setNonWildcardTypeArguments(BaseTypeArgument nonWildcardTypeArguments) {
        this.nonWildcardTypeArguments = nonWildcardTypeArguments;
    }

    @Override
    public BaseExpression getParameters() {
        return this.parameters;
    }

    public void setParameters(BaseExpression parameters) {
        this.parameters = parameters;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    public Map<String, BaseType> getTypeBounds() {
        return this.typeBounds;
    }

    public void setTypeBounds(Map<String, BaseType> typeBounds) {
        this.typeBounds = typeBounds;
    }

    public Map<String, TypeArgument> getTypeBindings() {
        return this.typeBindings;
    }

    public void setTypeBindings(Map<String, TypeArgument> typeBindings) {
        this.typeBindings = typeBindings;
    }

    @Override
    public boolean isMethodInvocationExpression() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression copyTo(int lineNumber) {
        return new MethodInvocationExpression(lineNumber, this.getType(), this.expression, this.getInternalTypeName(), this.name, this.descriptor, this.parameters, this.methodTypes);
    }

    @Override
    public String toString() {
        return "MethodInvocationExpression{call " + this.expression + " . " + this.name + "(" + this.descriptor + ")}";
    }
}

