/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberTypeExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;

public class IntegerConstantExpression
extends AbstractLineNumberTypeExpression {
    private final int value;

    public IntegerConstantExpression(Type type, int value) {
        this(0, type, value);
    }

    public IntegerConstantExpression(int lineNumber, Type type, int value) {
        super(lineNumber, type);
        this.value = value;
    }

    public IntegerConstantExpression(int lineNumber, int value) {
        this(lineNumber, PrimitiveTypeUtil.getPrimitiveTypeFromValue(value), value);
    }

    public IntegerConstantExpression(int value) {
        this(0, value);
    }

    @Override
    public int getIntegerValue() {
        return this.value;
    }

    @Override
    public void setType(Type type) {
        if (!this.checkType(type)) {
            throw new IllegalArgumentException("IntegerConstantExpression.setType(type) : incompatible types");
        }
        super.setType(type);
    }

    protected boolean checkType(Type type) {
        if (type.isPrimitiveType()) {
            PrimitiveType valueType = PrimitiveTypeUtil.getPrimitiveTypeFromValue(this.value);
            return (((PrimitiveType)type).getFlags() & valueType.getFlags()) != 0;
        }
        return false;
    }

    @Override
    public boolean isIntegerConstantExpression() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "IntegerConstantExpression{type=" + this.getType() + ", value=" + this.value + "}";
    }

    @Override
    public Expression copyTo(int lineNumber) {
        return new IntegerConstantExpression(lineNumber, this.getType(), this.value);
    }
}

