/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberTypeExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;

public class FloatConstantExpression
extends AbstractLineNumberTypeExpression {
    private final float value;

    public FloatConstantExpression(float value) {
        super(PrimitiveType.TYPE_FLOAT);
        this.value = value;
    }

    public FloatConstantExpression(int lineNumber, float value) {
        super(lineNumber, PrimitiveType.TYPE_FLOAT);
        this.value = value;
    }

    @Override
    public float getFloatValue() {
        return this.value;
    }

    @Override
    public boolean isFloatConstantExpression() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "FloatConstantExpression{" + this.value + "}";
    }

    @Override
    public Expression copyTo(int lineNumber) {
        return new FloatConstantExpression(lineNumber, this.value);
    }
}

