/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberTypeExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;

public class DoubleConstantExpression
extends AbstractLineNumberTypeExpression {
    private final double value;

    public DoubleConstantExpression(double value) {
        super(PrimitiveType.TYPE_DOUBLE);
        this.value = value;
    }

    public DoubleConstantExpression(int lineNumber, double value) {
        super(lineNumber, PrimitiveType.TYPE_DOUBLE);
        this.value = value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public boolean isDoubleConstantExpression() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "DoubleConstantExpression{" + this.value + "}";
    }

    @Override
    public Expression copyTo(int lineNumber) {
        return new DoubleConstantExpression(lineNumber, this.value);
    }
}

