/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberTypeExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.Type;

public class CastExpression
extends AbstractLineNumberTypeExpression {
    private Expression expression;
    private boolean explicit;
    private boolean byteCodeCheckCast;

    public CastExpression(Type type, Expression expression) {
        this(0, type, expression);
    }

    public CastExpression(int lineNumber, Type type, Expression expression) {
        this(lineNumber, type, expression, true);
    }

    public CastExpression(int lineNumber, Type type, Expression expression, boolean explicit) {
        this(lineNumber, type, expression, explicit, false);
    }

    public CastExpression(int lineNumber, Type type, Expression expression, boolean explicit, boolean byteCodeCheckCast) {
        super(lineNumber, type);
        this.expression = expression;
        this.explicit = explicit;
        this.byteCodeCheckCast = byteCodeCheckCast;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    public boolean isByteCodeCheckCast() {
        return this.byteCodeCheckCast;
    }

    public void setByteCodeCheckCast(boolean byteCodeCheckCast) {
        this.byteCodeCheckCast = byteCodeCheckCast;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public boolean isCastExpression() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "CastExpression{cast (" + this.getType() + ") " + this.expression + "}";
    }

    @Override
    public Expression copyTo(int lineNumber) {
        return new CastExpression(lineNumber, this.getType(), this.expression, this.explicit, this.byteCodeCheckCast);
    }
}

