/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;

public class BooleanExpression
extends AbstractLineNumberExpression {
    public static final BooleanExpression TRUE = new BooleanExpression(true);
    private final boolean value;

    protected BooleanExpression(boolean value) {
        this.value = value;
    }

    public BooleanExpression(int lineNumber, boolean value) {
        super(lineNumber);
        this.value = value;
    }

    @Override
    public Type getType() {
        return PrimitiveType.TYPE_BOOLEAN;
    }

    public boolean isTrue() {
        return this.value;
    }

    public boolean isFalse() {
        return !this.value;
    }

    @Override
    public boolean isBooleanExpression() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "BooleanExpression{" + this.value + "}";
    }

    @Override
    public Expression copyTo(int lineNumber) {
        return new BooleanExpression(lineNumber, this.value);
    }
}

