/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.declaration;

import java.util.List;
import org.jd.core.v1.model.javasyntax.declaration.DeclarationVisitor;
import org.jd.core.v1.model.javasyntax.declaration.TypeDeclaration;

public class ModuleDeclaration
extends TypeDeclaration {
    private final String version;
    private final List<ModuleInfo> requires;
    private final List<PackageInfo> exports;
    private final List<PackageInfo> opens;
    private final List<String> uses;
    private final List<ServiceInfo> provides;

    public ModuleDeclaration(int flags, String internalName, String name, String version, List<ModuleInfo> requires, List<PackageInfo> exports, List<PackageInfo> opens, List<String> uses, List<ServiceInfo> provides) {
        super(null, flags, internalName, name, null);
        this.version = version;
        this.requires = requires;
        this.exports = exports;
        this.opens = opens;
        this.uses = uses;
        this.provides = provides;
    }

    public String getVersion() {
        return this.version;
    }

    public List<ModuleInfo> getRequires() {
        return this.requires;
    }

    public List<PackageInfo> getExports() {
        return this.exports;
    }

    public List<PackageInfo> getOpens() {
        return this.opens;
    }

    public List<String> getUses() {
        return this.uses;
    }

    public List<ServiceInfo> getProvides() {
        return this.provides;
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "ModuleDeclaration{" + this.internalTypeName + "}";
    }

    public record ServiceInfo(String interfaceTypeName, List<String> implementationTypeNames) {
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ServiceInfo{interfaceTypeName=").append(this.interfaceTypeName);
            if (this.implementationTypeNames != null) {
                sb.append(", implementationTypeNames=").append(this.implementationTypeNames);
            }
            return sb.append("}").toString();
        }
    }

    public record PackageInfo(String internalName, int flags, List<String> moduleInfoNames) {
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("PackageInfo{internalName=").append(this.internalName);
            sb.append(", flags=").append(this.flags);
            if (this.moduleInfoNames != null) {
                sb.append(", moduleInfoNames=").append(this.moduleInfoNames);
            }
            return sb.append("}").toString();
        }
    }

    public record ModuleInfo(String name, int flags, String version) {
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ModuleInfo{name=").append(this.name);
            sb.append(", flags=").append(this.flags);
            if (this.version != null) {
                sb.append(", version=").append(this.version);
            }
            return sb.append("}").toString();
        }
    }
}

