/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.classfile;

import java.util.List;
import java.util.stream.Stream;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;

public class ClassFile {
    private final JavaClass javaClass;
    private ClassFile outerClassFile;
    private List<ClassFile> innerClassFiles;

    public ClassFile(JavaClass javaClass) {
        this.javaClass = javaClass;
    }

    public boolean isModule() {
        return (this.javaClass.getAccessFlags() & Short.MIN_VALUE) != 0;
    }

    public ClassFile getOuterClassFile() {
        return this.outerClassFile;
    }

    public void setOuterClassFile(ClassFile outerClassFile) {
        this.outerClassFile = outerClassFile;
    }

    public List<ClassFile> getInnerClassFiles() {
        return this.innerClassFiles;
    }

    public void setInnerClassFiles(List<ClassFile> innerClassFiles) {
        this.innerClassFiles = innerClassFiles;
    }

    public final boolean isAbstract() {
        return this.javaClass.isAbstract();
    }

    public final boolean isEnum() {
        return this.javaClass.isEnum();
    }

    public final boolean isInterface() {
        return this.javaClass.isInterface();
    }

    public final boolean isPublic() {
        return this.javaClass.isPublic();
    }

    public final boolean isStatic() {
        return this.javaClass.isStatic();
    }

    public int getMajorVersion() {
        return this.javaClass.getMajor();
    }

    public int getMinorVersion() {
        return this.javaClass.getMinor();
    }

    public final boolean isClass() {
        return this.javaClass.isClass();
    }

    public final int getAccessFlags() {
        return this.javaClass.getAccessFlags();
    }

    public final void setAccessFlags(int accessFlags) {
        this.javaClass.setAccessFlags(accessFlags);
    }

    public boolean isAnnotation() {
        return this.javaClass.isAnnotation();
    }

    public Method[] getMethods() {
        return this.javaClass.getMethods();
    }

    public Field[] getFields() {
        return this.javaClass.getFields();
    }

    public String[] getInterfaceTypeNames() {
        int[] interfaceIndices = this.javaClass.getInterfaceIndices();
        String[] interfaceNames = new String[interfaceIndices.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            interfaceNames[i] = this.getConstantPool().getConstantString(interfaceIndices[i], (byte)7);
        }
        return interfaceNames;
    }

    public String getSuperTypeName() {
        return this.getConstantPool().getConstantString(this.getSuperclassNameIndex(), (byte)7);
    }

    public int getSuperclassNameIndex() {
        return this.javaClass.getSuperclassNameIndex();
    }

    public String getInternalTypeName() {
        return Utility.packageToPath((String)this.javaClass.getClassName());
    }

    public ConstantPool getConstantPool() {
        return this.javaClass.getConstantPool();
    }

    public Attribute[] getAttributes() {
        return this.javaClass.getAttributes();
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.javaClass.getAnnotationEntries();
    }

    public <T extends Attribute> T getAttribute(byte tag) {
        return (T)((Attribute)Stream.of(this.javaClass.getAttributes()).filter(a -> a.getTag() == tag).findAny().orElse(null));
    }

    public boolean isAInnerClass() {
        return this.outerClassFile != null;
    }

    public String toString() {
        return "ClassFile{" + this.getInternalTypeName() + "}";
    }
}

