/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jd.core.v1.api.loader.Loader;

public class ClassPathLoader
implements Loader {
    private static String getPathForInternalName(String internalName) {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(internalName);
        if (!internalName.endsWith(".class")) {
            path.append(".class");
        }
        return path.toString();
    }

    @Override
    public byte[] load(String internalName) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(ClassPathLoader.getPathForInternalName(internalName));
        if (is == null) {
            return null;
        }
        try (InputStream in = is;){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                byte[] buffer = new byte[2048];
                int read = in.read(buffer);
                while (read > 0) {
                    out.write(buffer, 0, read);
                    read = in.read(buffer);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public boolean canLoad(String internalName) {
        return this.getClass().getResource(ClassPathLoader.getPathForInternalName(internalName)) != null;
    }
}

