/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.util;

import java.util.Arrays;
import org.apache.bcel.Const;

public final class ByteCodeUtil {
    private ByteCodeUtil() {
    }

    public static int nextTableSwitchOffset(byte[] code, int index) {
        int i = index + 4 & 0xFFFC;
        int low = (code[i += 4] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
        int high = (code[i += 4] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
        i += 4;
        return (i += 4 * (high - low + 1)) - 1;
    }

    public static int nextLookupSwitchOffset(byte[] code, int index) {
        int i = index + 4 & 0xFFFC;
        int npairs = (code[i += 4] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
        i += 4;
        return (i += 8 * npairs) - 1;
    }

    public static int nextWideOffset(byte[] code, int index) {
        int opcode = code[index + 1] & 0xFF;
        return index + (opcode == 132 ? 5 : 3);
    }

    public static int nextInstructionOffset(byte[] code, int index) {
        int opcode = code[index] & 0xFF;
        return switch (opcode) {
            case 170 -> ByteCodeUtil.nextTableSwitchOffset(code, index);
            case 171 -> ByteCodeUtil.nextLookupSwitchOffset(code, index);
            case 196 -> ByteCodeUtil.nextWideOffset(code, index);
            default -> index + 1 + Const.getNoOfOperands((int)opcode);
        };
    }

    public static boolean jumpTo(byte[] code, int offset, int targetOffset) {
        if (offset != -1) {
            int codeLength = code.length;
            for (int i = 0; i < 10; ++i) {
                if (offset == targetOffset) {
                    return true;
                }
                if (offset >= codeLength) break;
                int opcode = code[offset] & 0xFF;
                if (opcode == 167) {
                    offset += (short)((code[offset + 1] & 0xFF) << 8 | code[offset + 2] & 0xFF);
                    continue;
                }
                if (opcode != 200) break;
                offset += (code[offset + 1] & 0xFF) << 24 | (code[offset + 2] & 0xFF) << 16 | (code[offset + 3] & 0xFF) << 8 | code[offset + 4] & 0xFF;
            }
        }
        return false;
    }

    public static byte[] cleanUpByteCode(byte[] code) {
        for (int i = 0; i < code.length; ++i) {
            int clearFromIdx;
            boolean canCopy;
            int offset = i;
            if (!ByteCodeUtil.opCodeIn(code, offset, 25, 42, 43, 44, 45) || ByteCodeUtil.getOpCode(code, offset) == 25 && ByteCodeUtil.opCodeIn(code, ++offset, 42, 43, 44, 45) || ++offset >= code.length) continue;
            while (offset < code.length && ByteCodeUtil.opCodeIn(code, offset, 180, 182, 183, 184, 185, 192)) {
                offset += 1 + Const.getNoOfOperands((int)ByteCodeUtil.getOpCode(code, offset));
            }
            if (offset >= code.length || !ByteCodeUtil.opCodeIn(code, offset, 58, 75, 76, 77, 78)) continue;
            int paramEndIdx = offset;
            int astore1stIdxParam = ByteCodeUtil.getOpCode(code, offset) == 58 ? code[++offset] : code[offset] - 75;
            if (++offset >= code.length || ByteCodeUtil.getOpCode(code, offset) != 1 || ++offset >= code.length || !ByteCodeUtil.opCodeIn(code, offset, 58, 75, 76, 77, 78) || (offset += 1 + Const.getNoOfOperands((int)ByteCodeUtil.getOpCode(code, offset))) >= code.length || !ByteCodeUtil.opCodeIn(code, offset, 25, 42, 43, 44, 45) || (ByteCodeUtil.getOpCode(code, offset) != 25 ? astore1stIdxParam != code[offset] - 42 : astore1stIdxParam != code[++offset])) continue;
            if (++offset >= code.length || ByteCodeUtil.getOpCode(code, offset) != 182) continue;
            int invokeVirtualIdx = offset;
            if (!ByteCodeUtil.opCodeIn(code, offset += 3, 58, 75, 76, 77, 78) || (offset += 1 + Const.getNoOfOperands((int)ByteCodeUtil.getOpCode(code, offset))) >= code.length || !ByteCodeUtil.opCodeIn(code, offset, 25, 42, 43, 44, 45) || (ByteCodeUtil.getOpCode(code, offset) != 25 ? astore1stIdxParam != code[offset] - 42 : astore1stIdxParam != code[++offset]) || ++offset >= code.length || !ByteCodeUtil.opCodeIn(code, offset, 25, 42, 43, 44, 45) || (ByteCodeUtil.getOpCode(code, offset) != 25 ? astore1stIdxParam + 2 != code[offset] - 42 : astore1stIdxParam + 2 != code[++offset])) continue;
            if (++offset >= code.length || ByteCodeUtil.getOpCode(code, offset) != 184) continue;
            int invokeStaticIdx = offset;
            if (!ByteCodeUtil.opCodeIn(code, offset += 3, 58, 75, 76, 77, 78) || (offset += 1 + Const.getNoOfOperands((int)ByteCodeUtil.getOpCode(code, offset))) >= code.length || !ByteCodeUtil.opCodeIn(code, offset, 25, 42, 43, 44, 45) || (ByteCodeUtil.getOpCode(code, offset) == 25 ? astore1stIdxParam + 1 != code[++offset] : astore1stIdxParam + 1 != code[offset] - 42)) continue;
            int paramLength = paramEndIdx - i;
            int newParamEndIdx = paramEndIdx + paramLength;
            int newInvokeVirtualIdx = ++offset - 6;
            int newInvokeStaticIdx = offset - 3;
            boolean bl = canCopy = newInvokeVirtualIdx >= newParamEndIdx;
            if (canCopy) {
                clearFromIdx = newParamEndIdx;
            } else {
                int astoreIdx = paramEndIdx;
                byte aloadCode = (byte)(code[astoreIdx] - 33);
                if (ByteCodeUtil.getOpCode(code, astoreIdx) == 58) {
                    code[astoreIdx + 2] = aloadCode;
                    code[astoreIdx + 3] = code[astoreIdx + 1];
                    code[astoreIdx + 4] = code[astoreIdx + 2];
                    code[astoreIdx + 5] = code[astoreIdx + 3];
                    clearFromIdx = astoreIdx + 6;
                } else {
                    code[astoreIdx + 1] = aloadCode;
                    code[astoreIdx + 2] = code[astoreIdx + 1];
                    clearFromIdx = astoreIdx + 3;
                }
            }
            System.arraycopy(code, invokeStaticIdx, code, newInvokeStaticIdx, 3);
            System.arraycopy(code, invokeVirtualIdx, code, newInvokeVirtualIdx, 3);
            if (canCopy) {
                System.arraycopy(code, i, code, paramEndIdx, paramLength);
            }
            Arrays.fill(code, clearFromIdx, newInvokeVirtualIdx, (byte)0);
        }
        return code;
    }

    public static boolean opCodeIn(byte[] code, int index, int ... values) {
        return Arrays.binarySearch(values, ByteCodeUtil.getOpCode(code, index)) >= 0;
    }

    public static int getOpCode(byte[] code, int index) {
        return code[index] & 0xFF;
    }

    public static boolean isLoadIntValue(int opcode) {
        return opcode == 256 || opcode == 16 || opcode == 17;
    }

    public static boolean isIfInstruction(int opcode, boolean includeComplex) {
        return opcode >= 260 && opcode <= 262 || includeComplex && opcode == 284;
    }

    public static boolean isIfOrGotoInstruction(int opcode, boolean includeComplex) {
        return ByteCodeUtil.isIfInstruction(opcode, includeComplex) || opcode == 167;
    }

    public static int getCmpPriority(int cmp) {
        return cmp == 0 || cmp == 7 ? 7 : 6;
    }

    public static boolean getArrayRefIndex(byte[] code) {
        return code.length == 5 && (code[0] & 0xFF) == 26 && (code[1] & 0xFF) == 189 && (code[4] & 0xFF) == 176;
    }

    public static int getLoadOpCode(int storeOpCode) {
        return switch (storeOpCode) {
            case 58 -> 25;
            case 54 -> 21;
            case 269 -> 268;
            case 181 -> 180;
            case 179 -> 178;
            default -> -1;
        };
    }
}

