/*
 * Decompiled with CFR 0.152.
 */
package jd.core.links;

public class DeclarationData {
    private final int startPosition;
    private final int endPosition;
    private final String typeName;
    private final String name;
    private final String descriptor;

    public DeclarationData(int startPosition, int length, String typeName, String name, String descriptor) {
        this.startPosition = startPosition;
        this.endPosition = startPosition + length;
        this.typeName = typeName;
        this.name = name;
        this.descriptor = descriptor;
    }

    public boolean isAType() {
        return this.getName() == null;
    }

    public boolean isAField() {
        return this.descriptor != null && this.descriptor.charAt(0) != '(';
    }

    public boolean isAMethod() {
        return this.descriptor != null && this.descriptor.charAt(0) == '(';
    }

    public boolean isAConstructor() {
        return "<init>".equals(this.getName());
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "DeclarationData [typeName=" + this.typeName + ", name=" + this.name + ", descriptor=" + this.descriptor + "]";
    }
}

