/*
 * Decompiled with CFR 0.152.
 */
package jd.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public interface VersionAware {
    default public String getVersion() throws IOException {
        return this.getMainAttribute("JD-Core-Version");
    }

    default public String getMainAttribute(String attributeName) throws IOException {
        return this.getMainAttribute(this.getClass(), attributeName);
    }

    default public String getMainAttribute(Class<?> clazz, String attributeName) throws IOException {
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return this.findFirstMainAttribute(attributeName);
        }
        URL url = new URL(classPath);
        JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
        Manifest manifest = jarConnection.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(attributeName);
    }

    default public String findFirstMainAttribute(String attributeName) throws IOException {
        Enumeration<URL> manifestURLs = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (manifestURLs.hasMoreElements()) {
            URL manifestUrl = manifestURLs.nextElement();
            InputStream inputStream = manifestUrl.openStream();
            try {
                Manifest manifest = new Manifest(inputStream);
                Attributes attributes = manifest.getMainAttributes();
                String attributeValue = attributes.getValue(attributeName);
                if (attributeValue == null) continue;
                String string = attributeValue;
                return string;
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return "SNAPSHOT";
    }
}

