/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.util;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.Types;
import com.strobel.util.ContractUtils;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.type.TypeKind;

public final class TypeUtils {
    private TypeUtils() {
        throw ContractUtils.unreachable();
    }

    public static boolean isAutoUnboxed(Type<?> type) {
        return type == Types.Integer || type == Types.Long || type == Types.Double || type == Types.Float || type == Types.Short || type == Types.Byte || type == Types.Boolean || type == Types.Character;
    }

    public static Type<?> getUnderlyingPrimitive(Type<?> type) {
        if (type == Types.Integer) {
            return PrimitiveTypes.Integer;
        }
        if (type == Types.Long) {
            return PrimitiveTypes.Long;
        }
        if (type == Types.Double) {
            return PrimitiveTypes.Double;
        }
        if (type == Types.Float) {
            return PrimitiveTypes.Float;
        }
        if (type == Types.Short) {
            return PrimitiveTypes.Short;
        }
        if (type == Types.Byte) {
            return PrimitiveTypes.Byte;
        }
        if (type == Types.Boolean) {
            return PrimitiveTypes.Boolean;
        }
        if (type == Types.Character) {
            return PrimitiveTypes.Character;
        }
        return null;
    }

    public static Type<?> getBoxedTypeOrSelf(Type<?> type) {
        Type<?> boxedType = TypeUtils.getBoxedType(type);
        return boxedType != null ? boxedType : type;
    }

    public static Type<?> getUnderlyingPrimitiveOrSelf(Type<?> type) {
        Type<?> underlyingPrimitive = TypeUtils.getUnderlyingPrimitive(type);
        return underlyingPrimitive != null ? underlyingPrimitive : type;
    }

    public static Type<?> getBoxedType(Type<?> type) {
        if (TypeUtils.isAutoUnboxed(type)) {
            return type;
        }
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == PrimitiveTypes.Integer) {
            return Types.Integer;
        }
        if (type == PrimitiveTypes.Long) {
            return Types.Long;
        }
        if (type == PrimitiveTypes.Double) {
            return Types.Double;
        }
        if (type == PrimitiveTypes.Float) {
            return Types.Float;
        }
        if (type == PrimitiveTypes.Short) {
            return Types.Short;
        }
        if (type == PrimitiveTypes.Byte) {
            return Types.Byte;
        }
        if (type == PrimitiveTypes.Boolean) {
            return Types.Boolean;
        }
        if (type == PrimitiveTypes.Character) {
            return Types.Character;
        }
        return null;
    }

    public static boolean isArithmetic(Type<?> type) {
        return TypeUtils.isNumeric(type) || type == PrimitiveTypes.Character || type == Types.Character;
    }

    public static boolean isNumeric(Type<?> type) {
        Type<?> underlyingPrimitive = TypeUtils.getUnderlyingPrimitive(type);
        Type<?> actualType = underlyingPrimitive != null ? underlyingPrimitive : type;
        return actualType == PrimitiveTypes.Integer || actualType == PrimitiveTypes.Long || actualType == PrimitiveTypes.Double || actualType == PrimitiveTypes.Float || actualType == PrimitiveTypes.Short || actualType == PrimitiveTypes.Byte || actualType == PrimitiveTypes.Character;
    }

    public static boolean isIntegralOrBoolean(Type<?> type) {
        Type<?> underlyingPrimitive = TypeUtils.getUnderlyingPrimitive(type);
        Type<?> actualType = underlyingPrimitive != null ? underlyingPrimitive : type;
        return actualType == PrimitiveTypes.Integer || actualType == PrimitiveTypes.Long || actualType == PrimitiveTypes.Short || actualType == PrimitiveTypes.Byte || actualType == PrimitiveTypes.Character || actualType == PrimitiveTypes.Boolean;
    }

    public static boolean isIntegral(Type<?> type) {
        Type<?> underlyingPrimitive = TypeUtils.getUnderlyingPrimitive(type);
        Type<?> actualType = underlyingPrimitive != null ? underlyingPrimitive : type;
        return actualType == PrimitiveTypes.Integer || actualType == PrimitiveTypes.Long || actualType == PrimitiveTypes.Short || actualType == PrimitiveTypes.Byte || actualType == PrimitiveTypes.Character;
    }

    public static boolean isBoolean(Type<?> type) {
        return type == PrimitiveTypes.Boolean || type == Types.Boolean;
    }

    public static boolean areEquivalent(Type<?> class1, Type<?> class2) {
        return class1 == null ? class2 == null : class1.isEquivalentTo(class2);
    }

    public static boolean areEquivalentWithOrdering(TypeList types1, TypeList types2) {
        if (types1 == types2) {
            return true;
        }
        if (types1 == null || types2 == null || types1.size() != types2.size()) {
            return false;
        }
        int n = types1.size();
        for (int i = 0; i < n; ++i) {
            if (TypeUtils.areEquivalent((Type)types1.get(i), (Type)types2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalent(TypeList types1, TypeList types2) {
        if (TypeUtils.areEquivalentWithOrdering(types1, types2)) {
            return true;
        }
        if (types1 == types2) {
            return true;
        }
        if (types1 == null || types2 == null || types1.size() != types2.size()) {
            return false;
        }
        HashSet set1 = new HashSet(types1);
        HashSet set2 = new HashSet(types2);
        return set1.size() == set2.size() && set1.containsAll(set2);
    }

    public static boolean hasIdentityPrimitiveOrBoxingConversion(Type<?> source, Type<?> destination) {
        Type<?> unboxedDestination;
        assert (source != null && destination != null);
        if (source == Types.Object || destination == Types.Object) {
            return true;
        }
        Type<?> unboxedSource = TypeUtils.getUnderlyingPrimitiveOrSelf(source);
        return unboxedSource == (unboxedDestination = TypeUtils.getUnderlyingPrimitiveOrSelf(destination)) || TypeUtils.areEquivalent(unboxedSource, unboxedDestination);
    }

    public static boolean hasReferenceConversion(Type<?> source, Type<?> destination) {
        assert (source != null && destination != null);
        if (source == PrimitiveTypes.Void || destination == PrimitiveTypes.Void) {
            return false;
        }
        if (TypeUtils.areEquivalent(source, destination)) {
            return true;
        }
        if (source.isPrimitive() || destination.isPrimitive()) {
            return false;
        }
        if (source == Types.Object || destination == Types.Object) {
            return true;
        }
        if (source.isInterface() || destination.isInterface()) {
            return true;
        }
        if (destination.isAssignableFrom(source)) {
            return true;
        }
        return source.isAssignableFrom(destination);
    }

    public static MethodInfo getCoercionMethod(Type<?> source, Type<?> destination) {
        Type<?> unboxedDestinationType;
        Type<?> type = unboxedDestinationType = TypeUtils.isAutoUnboxed(destination) ? TypeUtils.getUnderlyingPrimitive(destination) : destination;
        if (destination == Types.String) {
            return Types.String.getMethod("valueOf", source);
        }
        MethodInfo method = destination == PrimitiveTypes.Integer ? source.getMethod("intValue", BindingFlags.PublicInstance, new Type[0]) : (destination == PrimitiveTypes.Long ? source.getMethod("longValue", BindingFlags.PublicInstance, new Type[0]) : (destination == PrimitiveTypes.Double ? source.getMethod("doubleValue", BindingFlags.PublicInstance, new Type[0]) : (destination == PrimitiveTypes.Float ? source.getMethod("floatValue", BindingFlags.PublicInstance, new Type[0]) : (destination == PrimitiveTypes.Short ? source.getMethod("shortValue", BindingFlags.PublicInstance, new Type[0]) : (destination == PrimitiveTypes.Byte ? source.getMethod("byteValue", BindingFlags.PublicInstance, new Type[0]) : (destination == PrimitiveTypes.Boolean ? source.getMethod("booleanValue", BindingFlags.PublicInstance, new Type[0]) : (destination == PrimitiveTypes.Character ? source.getMethod("charValue", BindingFlags.PublicInstance, new Type[0]) : destination.getMethod("valueOf", BindingFlags.PublicStatic, source))))))));
        if (method == null) {
            return null;
        }
        if (method.getReturnType() == unboxedDestinationType) {
            return method;
        }
        return null;
    }

    public static MethodInfo getBoxMethod(Type<?> type) {
        Type<?> boxedType = TypeUtils.getBoxedTypeOrSelf(type);
        Type<?> primitiveType = TypeUtils.getUnderlyingPrimitive(boxedType);
        if (primitiveType == null) {
            return null;
        }
        MethodInfo boxMethod = boxedType.getMethod("valueOf", BindingFlags.PublicStatic, primitiveType);
        if (boxMethod == null || !TypeUtils.areEquivalent(boxMethod.getReturnType(), boxedType)) {
            return null;
        }
        return boxMethod;
    }

    public static MethodInfo getUnboxMethod(Type<?> type) {
        MethodInfo unboxMethod;
        Type<?> boxedType = TypeUtils.getBoxedTypeOrSelf(type);
        Type<?> primitiveType = TypeUtils.getUnderlyingPrimitive(boxedType);
        if (primitiveType == null) {
            return null;
        }
        Set<BindingFlags> bindingFlags = BindingFlags.PublicInstance;
        switch (primitiveType.getKind()) {
            case BOOLEAN: {
                unboxMethod = boxedType.getMethod("booleanValue", bindingFlags, new Type[0]);
                break;
            }
            case BYTE: {
                unboxMethod = boxedType.getMethod("byteValue", bindingFlags, new Type[0]);
                break;
            }
            case SHORT: {
                unboxMethod = boxedType.getMethod("shortValue", bindingFlags, new Type[0]);
                break;
            }
            case INT: {
                unboxMethod = boxedType.getMethod("intValue", bindingFlags, new Type[0]);
                break;
            }
            case LONG: {
                unboxMethod = boxedType.getMethod("longValue", bindingFlags, new Type[0]);
                break;
            }
            case CHAR: {
                unboxMethod = boxedType.getMethod("charValue", bindingFlags, new Type[0]);
                break;
            }
            case FLOAT: {
                unboxMethod = boxedType.getMethod("floatValue", bindingFlags, new Type[0]);
                break;
            }
            case DOUBLE: {
                unboxMethod = boxedType.getMethod("doubleValue", bindingFlags, new Type[0]);
                break;
            }
            default: {
                unboxMethod = null;
            }
        }
        if (unboxMethod == null || !TypeUtils.areEquivalent(unboxMethod.getReturnType(), primitiveType)) {
            return null;
        }
        return unboxMethod;
    }

    public static MethodInfo getUnboxMethod(Type<?> boxedType, Type<?> unboxedType) {
        MethodInfo unboxMethod;
        Set<BindingFlags> bindingFlags = BindingFlags.PublicInstance;
        switch (unboxedType.getKind()) {
            case BOOLEAN: {
                unboxMethod = boxedType.getMethod("booleanValue", bindingFlags, new Type[0]);
                break;
            }
            case BYTE: {
                unboxMethod = boxedType.getMethod("byteValue", bindingFlags, new Type[0]);
                break;
            }
            case SHORT: {
                unboxMethod = boxedType.getMethod("shortValue", bindingFlags, new Type[0]);
                break;
            }
            case INT: {
                unboxMethod = boxedType.getMethod("intValue", bindingFlags, new Type[0]);
                break;
            }
            case LONG: {
                unboxMethod = boxedType.getMethod("longValue", bindingFlags, new Type[0]);
                break;
            }
            case CHAR: {
                unboxMethod = boxedType.getMethod("charValue", bindingFlags, new Type[0]);
                break;
            }
            case FLOAT: {
                unboxMethod = boxedType.getMethod("floatValue", bindingFlags, new Type[0]);
                break;
            }
            case DOUBLE: {
                unboxMethod = boxedType.getMethod("doubleValue", bindingFlags, new Type[0]);
                break;
            }
            default: {
                unboxMethod = null;
            }
        }
        if (unboxMethod == null || !TypeUtils.areEquivalent(unboxMethod.getReturnType(), unboxedType)) {
            return null;
        }
        return unboxMethod;
    }

    public static boolean areReferenceAssignable(Type<?> destination, Type<?> source) {
        if (destination == Types.Object) {
            return true;
        }
        return TypeUtils.hasIdentityPrimitiveOrBoxingConversion(source, destination) || !destination.isPrimitive() && !source.isPrimitive() && destination.isAssignableFrom(source);
    }

    public static boolean hasReferenceEquality(Type<?> left, Type<?> right) {
        if (left.isPrimitive() || right.isPrimitive()) {
            return false;
        }
        return left.isInterface() || right.isInterface() || TypeUtils.areReferenceAssignable(left, right) || TypeUtils.areReferenceAssignable(right, left);
    }

    public static boolean hasBuiltInEqualityOperator(Type<?> left, Type<?> right) {
        if (left.isPrimitive() || right.isPrimitive()) {
            if (left == PrimitiveTypes.Boolean) {
                return TypeUtils.hasIdentityPrimitiveOrBoxingConversion(left, right);
            }
            if (right == PrimitiveTypes.Boolean) {
                return TypeUtils.hasIdentityPrimitiveOrBoxingConversion(right, left);
            }
            return TypeUtils.isArithmetic(left) && TypeUtils.isArithmetic(right);
        }
        return left.isEnum() && TypeUtils.hasIdentityPrimitiveOrBoxingConversion(left, right) || right.isEnum() && TypeUtils.hasIdentityPrimitiveOrBoxingConversion(right, left);
    }

    public static boolean isValidInvocationTargetType(MethodInfo method, Type<?> targetType) {
        Type<?> declaringType = method.getDeclaringType();
        return TypeUtils.areReferenceAssignable(declaringType, targetType) || targetType.isSubTypeOf(declaringType);
    }

    public static boolean isSameOrSubType(Type<?> type, Type<?> subType) {
        return TypeUtils.areEquivalent(type, subType) || subType.isSubTypeOf(type);
    }

    public static boolean isImplicitNumericConversion(Type<?> sourceType, Type<?> targetType) {
        TypeKind sourceKind = TypeUtils.getUnderlyingPrimitiveOrSelf(sourceType).getKind();
        TypeKind targetKind = TypeUtils.getUnderlyingPrimitiveOrSelf(targetType).getKind();
        switch (sourceKind) {
            case BYTE: {
                switch (targetKind) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case CHAR: 
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case SHORT: {
                switch (targetKind) {
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case CHAR: 
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case INT: {
                switch (targetKind) {
                    case INT: 
                    case LONG: 
                    case CHAR: 
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case CHAR: {
                switch (targetKind) {
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case CHAR: 
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case LONG: {
                switch (targetKind) {
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case FLOAT: {
                switch (targetKind) {
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case DOUBLE: {
                return targetKind == TypeKind.DOUBLE;
            }
        }
        return false;
    }

    public static String getInternalName(@NotNull Class<?> clazz) {
        VerifyArgument.notNull(clazz, (String)"clazz");
        StringBuilder sb = new StringBuilder(clazz.getName());
        int n = sb.length();
        for (int i = 0; i < n; ++i) {
            if (sb.charAt(i) != '.') continue;
            sb.setCharAt(i, '/');
        }
        return sb.toString();
    }

    public static boolean isSingleWord(Type<?> type) {
        return TypeUtils.isSingleWord(type.getKind());
    }

    public static boolean isSingleWord(TypeKind kind) {
        switch (kind) {
            case LONG: 
            case DOUBLE: 
            case VOID: {
                return false;
            }
        }
        return true;
    }

    public static boolean isDoubleWord(Type<?> type) {
        return TypeUtils.isDoubleWord(type.getKind());
    }

    public static boolean isDoubleWord(TypeKind kind) {
        switch (kind) {
            case LONG: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumeric(TypeKind kind) {
        switch (kind) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case CHAR: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntegral(TypeKind kind) {
        switch (kind) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case CHAR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSubWordOrInt32(Type<?> type) {
        return TypeUtils.isSubWordOrInt32(type.getKind());
    }

    public static boolean isSubWordOrInt32(TypeKind kind) {
        switch (kind) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case CHAR: {
                return true;
            }
        }
        return false;
    }

    public static int bitWidth(Type<?> type) {
        return TypeUtils.bitWidth(type.getKind());
    }

    public static int bitWidth(TypeKind kind) {
        switch (kind) {
            case BOOLEAN: {
                return 1;
            }
            case BYTE: {
                return 8;
            }
            case SHORT: 
            case CHAR: {
                return 16;
            }
            case INT: {
                return 32;
            }
            case LONG: {
                return 64;
            }
            case FLOAT: {
                return 32;
            }
            case DOUBLE: {
                return 64;
            }
        }
        return 0;
    }
}

