/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.annotations.NotNull;
import com.strobel.core.ReadOnlyList;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.Flags;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.SignatureType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.emit.AnnotationBuilder;
import com.strobel.reflection.emit.CodeGenerator;
import com.strobel.reflection.emit.Error;
import com.strobel.reflection.emit.MethodBuilder;
import com.strobel.reflection.emit.ParameterBuilder;
import com.strobel.reflection.emit.TypeBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class ConstructorBuilder
extends ConstructorInfo {
    private final MethodBuilder _methodBuilder;
    boolean returnCodeGenerator = true;
    ConstructorInfo generatedConstructor;

    public ConstructorBuilder(int modifiers, TypeList parameterTypes, TypeList thrownTypes, TypeBuilder<?> declaringType) {
        this._methodBuilder = new MethodBuilder("<init>", modifiers, null, parameterTypes, thrownTypes, declaringType);
        declaringType.addMethodToList(this._methodBuilder);
    }

    private void verifyTypeCreated() {
        ((TypeBuilder)this._methodBuilder.getDeclaringType()).verifyCreated();
    }

    public boolean isFinished() {
        return this._methodBuilder.isFinished();
    }

    public boolean isTypeCreated() {
        return this._methodBuilder.isTypeCreated();
    }

    public MethodBuilder getMethodBuilder() {
        return this._methodBuilder;
    }

    public CodeGenerator getCodeGenerator() {
        if (!this.returnCodeGenerator) {
            throw Error.noCodeGeneratorForDefaultConstructor();
        }
        return this._methodBuilder.getCodeGenerator();
    }

    @Override
    public Constructor<?> getRawConstructor() {
        this.verifyTypeCreated();
        return null;
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        TypeList parameterTypes = this.getParameterTypes();
        StringBuilder s = sb;
        s.append('(');
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            s = ((Type)parameterTypes.get(i)).getErasedType().appendErasedSignature(s);
        }
        s.append(')');
        s = PrimitiveTypes.Void.appendErasedSignature(s);
        return s;
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers())) {
            sb.append(modifier.toString());
            sb.append(' ');
        }
        StringBuilder s = PrimitiveTypes.Void.appendBriefDescription(sb);
        s.append(' ');
        s.append(this.getName());
        s.append('(');
        ParameterBuilder[] parameters = this._methodBuilder.parameterBuilders;
        int n = parameters.length;
        for (int i = 0; i < n; ++i) {
            ParameterBuilder p = parameters[i];
            if (i != 0) {
                s.append(", ");
            }
            s = p.getParameterType().appendSimpleDescription(s);
        }
        s.append(')');
        TypeList thrownTypes = this.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            s.append(" throws ");
            int n2 = thrownTypes.size();
            for (int i = 0; i < n2; ++i) {
                Type t = (Type)thrownTypes.get(i);
                if (i != 0) {
                    s.append(", ");
                }
                s = t.appendSimpleDescription(s);
            }
        }
        return s;
    }

    public TypeBuilder<?> getDeclaringType() {
        return this._methodBuilder.getDeclaringType();
    }

    @Override
    public int getModifiers() {
        return this._methodBuilder.getModifiers();
    }

    @Override
    public SignatureType getSignatureType() {
        return this._methodBuilder.getSignatureType();
    }

    @Override
    public ParameterList getParameters() {
        return this.isTypeCreated() ? this.generatedConstructor.getParameters() : this._methodBuilder.createParameters();
    }

    public TypeList getParameterTypes() {
        return this._methodBuilder.getParameterTypes();
    }

    public void setParameterTypes(TypeList parameterTypes) {
        this._methodBuilder.setSignature(null, parameterTypes);
        this.invalidateCaches();
    }

    public List<ParameterBuilder> getDefinedParameters() {
        return this._methodBuilder.getDefinedParameters();
    }

    public void defineParameter(int position, String name) {
        this._methodBuilder.defineParameter(position, name);
    }

    @Override
    public Type<?> getReflectedType() {
        return this._methodBuilder.getReflectedType();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._methodBuilder.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this._methodBuilder.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this._methodBuilder.getDeclaredAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._methodBuilder.isAnnotationPresent(annotationClass);
    }

    public void addCustomAnnotation(AnnotationBuilder<? extends Annotation> annotation) {
        this._methodBuilder.addCustomAnnotation(annotation);
    }

    public ReadOnlyList<AnnotationBuilder<? extends Annotation>> getCustomAnnotations() {
        return this._methodBuilder.getCustomAnnotations();
    }
}

