/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.Fences;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeVisitor;
import com.strobel.reflection.Types;
import javax.lang.model.type.TypeKind;

class WildcardType<T>
extends Type<T> {
    private final Type<T> _extendsBound;
    private final Type<?> _superBound;
    private Class<T> _erasedClass;

    WildcardType(Type<T> extendsBound, Type<?> superBound) {
        this._extendsBound = extendsBound != null ? extendsBound : Types.Object;
        this._superBound = superBound != null ? superBound : Type.bottomType();
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        if (this._superBound != WildcardType.bottomType()) {
            return this._superBound.appendSignature(sb.append('-'));
        }
        if (this._extendsBound != Types.Object) {
            return this._extendsBound.appendSignature(sb.append('+'));
        }
        return sb.append('*');
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        if (this._superBound != WildcardType.bottomType()) {
            sb.append("? super ");
            if (this._superBound.isGenericParameter()) {
                return sb.append(this._superBound.getFullName());
            }
            return this._superBound.appendErasedDescription(sb);
        }
        if (this._extendsBound == Types.Object) {
            return sb.append("?");
        }
        sb.append("? extends ");
        if (this._extendsBound.isGenericParameter()) {
            return sb.append(this._extendsBound.getFullName());
        }
        return this._extendsBound.appendErasedDescription(sb);
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        if (this._superBound != WildcardType.bottomType()) {
            sb.append("? super ");
            if (this._superBound.isGenericParameter()) {
                return sb.append(this._superBound.getName());
            }
            return this._superBound.appendSimpleDescription(sb);
        }
        if (this._extendsBound == Types.Object) {
            return sb.append("?");
        }
        sb.append("? extends ");
        if (this._extendsBound.isGenericParameter()) {
            return sb.append(this._extendsBound.getName());
        }
        return this._extendsBound.appendSimpleDescription(sb);
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        return this.appendBriefDescription(sb);
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        return this.appendBriefDescription(sb);
    }

    private Class<T> resolveErasedClass() {
        return this._extendsBound.getErasedClass();
    }

    @Override
    public Type<?> getExtendsBound() {
        return this._extendsBound;
    }

    @Override
    public Type<?> getSuperBound() {
        return this._superBound;
    }

    @Override
    public boolean isWildcardType() {
        return true;
    }

    @Override
    public <P, R> R accept(TypeVisitor<P, R> visitor, P parameter) {
        return visitor.visitWildcardType(this, parameter);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.WILDCARD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<T> getErasedClass() {
        if (this._erasedClass == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._erasedClass == null) {
                    this._erasedClass = (Class)Fences.orderWrites(this.resolveErasedClass());
                }
            }
        }
        return this._erasedClass;
    }

    @Override
    public MemberType getMemberType() {
        return MemberType.TypeInfo;
    }

    @Override
    public Type<?> getDeclaringType() {
        return null;
    }

    @Override
    public int getModifiers() {
        return 1;
    }

    @Override
    public boolean isEquivalentTo(Type<?> other) {
        if (other == this) {
            return true;
        }
        if (other instanceof WildcardType) {
            WildcardType that = (WildcardType)other;
            return this._extendsBound.isEquivalentTo(that._extendsBound) && this._superBound.isEquivalentTo(that._superBound);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this._extendsBound.hashCode();
        result = 31 * result + this._superBound.hashCode();
        return result;
    }
}

