/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.RuntimeTypeCache;
import com.strobel.reflection.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Set;

final class RuntimeFieldInfo
extends FieldInfo {
    private final Field _rawField;
    private final Type<?> _declaringType;
    private final RuntimeTypeCache<?> _reflectedTypeCache;
    private final int _modifiers;
    private final Set<BindingFlags> _bindingFlags;
    private final Type<?> _fieldType;

    RuntimeFieldInfo(Field rawField, Type<?> declaringType, RuntimeTypeCache<?> reflectedTypeCache, int modifiers, Set<BindingFlags> bindingFlags, Type<?> fieldType) {
        this._rawField = (Field)VerifyArgument.notNull((Object)rawField, (String)"rawConstructor");
        this._declaringType = (Type)VerifyArgument.notNull(declaringType, (String)"declaringType");
        this._reflectedTypeCache = (RuntimeTypeCache)VerifyArgument.notNull(reflectedTypeCache, (String)"reflectedTypeCache");
        this._bindingFlags = (Set)VerifyArgument.notNull(bindingFlags, (String)"bindingFlags");
        this._modifiers = modifiers;
        this._fieldType = (Type)VerifyArgument.notNull(fieldType, (String)"fieldType");
    }

    Set<BindingFlags> getBindingFlags() {
        return this._bindingFlags;
    }

    @Override
    public Type<?> getFieldType() {
        return this._fieldType;
    }

    @Override
    public boolean isEnumConstant() {
        return false;
    }

    @Override
    public Field getRawField() {
        return this._rawField;
    }

    @Override
    public String getName() {
        return this._rawField.getName();
    }

    @Override
    public Type<?> getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public Type<?> getReflectedType() {
        return this._reflectedTypeCache.getRuntimeType();
    }

    @Override
    public int getModifiers() {
        return this._modifiers;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._rawField.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this._rawField.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this._rawField.getDeclaredAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._rawField.isAnnotationPresent(annotationClass);
    }

    @Override
    public boolean isEquivalentTo(MemberInfo m) {
        if (m == this) {
            return true;
        }
        if (m instanceof RuntimeFieldInfo) {
            RuntimeFieldInfo other = (RuntimeFieldInfo)m;
            if (other._declaringType == this._declaringType && other._rawField == this._rawField) {
                return true;
            }
        }
        return super.isEquivalentTo(m);
    }
}

