/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.Type;
import java.lang.reflect.Field;

class ReflectedField
extends FieldInfo {
    private final Type<?> _declaringType;
    private final Type<?> _reflectedType;
    private final Field _rawField;
    private final Type<?> _fieldType;

    ReflectedField(Type<?> declaringType, Field rawField, Type<?> fieldType) {
        this(declaringType, declaringType, rawField, fieldType);
    }

    ReflectedField(Type<?> declaringType, Type<?> reflectedType, Field rawField, Type<?> fieldType) {
        this._declaringType = (Type)VerifyArgument.notNull(declaringType, (String)"declaringType");
        this._reflectedType = (Type)VerifyArgument.notNull(reflectedType, (String)"reflectedType");
        this._rawField = (Field)VerifyArgument.notNull((Object)rawField, (String)"rawField");
        this._fieldType = (Type)VerifyArgument.notNull(fieldType, (String)"fieldType");
    }

    @Override
    public Field getRawField() {
        return this._rawField;
    }

    @Override
    public Type<?> getFieldType() {
        return this._fieldType;
    }

    @Override
    public boolean isEnumConstant() {
        return this._rawField.isEnumConstant();
    }

    @Override
    public String getName() {
        return this._rawField.getName();
    }

    @Override
    public Type<?> getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public Type<?> getReflectedType() {
        return this._reflectedType;
    }

    @Override
    public int getModifiers() {
        return this._rawField.getModifiers();
    }
}

