/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.DelegatingMethodInfo;
import com.strobel.reflection.ErasedType;
import com.strobel.reflection.Error;
import com.strobel.reflection.Flags;
import com.strobel.reflection.GenericMethod;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import com.strobel.util.ContractUtils;
import com.strobel.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;

public abstract class MethodInfo
extends MethodBase {
    private static final MethodInfo[] EMPTY_METHODS = new MethodInfo[0];
    protected MethodInfo _erasedMethodDefinition;

    public static MethodInfo[] emptyMethods() {
        return EMPTY_METHODS;
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public final boolean isDefault() {
        if (this.isAbstract() || this.isStatic()) {
            return false;
        }
        Type<?> declaringType = this.getDeclaringType();
        return declaringType != null && declaringType.isInterface();
    }

    public abstract Type<?> getReturnType();

    @Override
    public final MemberType getMemberType() {
        return MemberType.Method;
    }

    public abstract Method getRawMethod();

    public Object getDefaultValue() {
        return this.getRawMethod().getDefaultValue();
    }

    @Override
    public String getName() {
        return this.getRawMethod().getName();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getRawMethod().getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this.getRawMethod().getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this.getRawMethod().getDeclaredAnnotations();
    }

    @Override
    public boolean isEquivalentTo(MemberInfo m) {
        return m instanceof MethodInfo && super.isEquivalentTo(m) && ((MethodInfo)m).getReturnType().isEquivalentTo(this.getReturnType());
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getRawMethod().isAnnotationPresent(annotationClass);
    }

    public Object invoke(Object instance, Object ... args) {
        Method rawMethod = this.getRawMethod();
        if (rawMethod == null) {
            throw Error.rawMethodBindingFailure(this);
        }
        try {
            return rawMethod.invoke(instance, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Error.targetInvocationException(e);
        }
    }

    public MethodInfo findOverriddenMethod() {
        MethodInfo baseMethod;
        Type<?> baseType = this.getDeclaringType().getBaseType();
        if (baseType != null && baseType != Type.nullType() && (baseMethod = this.findBaseMethod(baseType)) != null) {
            return baseMethod;
        }
        Iterator iterator = this.getDeclaringType().getExplicitInterfaces().iterator();
        while (iterator.hasNext()) {
            Type ifType = (Type)iterator.next();
            baseMethod = this.findBaseMethod(ifType);
            if (baseMethod == null) continue;
            return baseMethod;
        }
        return null;
    }

    public MethodInfo findBaseMethod(Type<?> relativeTo) {
        VerifyArgument.notNull(relativeTo, (String)"relativeTo");
        Type<?> declaringType = this.getDeclaringType();
        if (!relativeTo.isAssignableFrom(declaringType)) {
            throw Error.invalidAncestorType(relativeTo, declaringType);
        }
        if (this.isStatic() || this.isPrivate()) {
            return null;
        }
        ParameterList parameters = this.getParameters();
        return relativeTo.getMethod(this.getName(), BindingFlags.AllInstance, this.getCallingConvention(), (Type[])parameters.getParameterTypes().toArray(new Type[parameters.size()]));
    }

    protected void appendModifiers(StringBuilder s, int modifiers) {
        for (javax.lang.model.element.Modifier modifier : Flags.asModifierSet(MemberType.Method, modifiers)) {
            s.append(modifier.toString());
            s.append(' ');
        }
        if (Flags.testAny((long)modifiers, 19327353024L)) {
            s.append("/* ");
            if (Flags.testAny((long)modifiers, 0x80000040L)) {
                s.append("bridge ");
            }
            if (Flags.testAny((long)modifiers, 0x400000080L)) {
                s.append("varargs ");
            }
            s.append("*/ ");
        }
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        StringBuilder s = new StringBuilder();
        int modifiers = this.getModifiers();
        this.appendModifiers(s, modifiers);
        if (this.isGenericMethodDefinition()) {
            TypeList genericParameters = this.getGenericMethodParameters();
            s.append('<');
            int n = genericParameters.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    s.append(", ");
                }
                s = ((Type)genericParameters.get(i)).appendSimpleDescription(s);
            }
            s.append('>');
            s.append(' ');
        }
        Type<?> returnType = this.getReturnType();
        while (returnType.isWildcardType()) {
            returnType = returnType.getExtendsBound();
        }
        if (returnType.isGenericParameter()) {
            s.append(returnType.getName());
        } else {
            s = returnType.appendSimpleDescription(s);
        }
        s.append(' ');
        s.append(this.getName());
        s.append('(');
        ParameterList parameters = this.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterInfo p = (ParameterInfo)parameters.get(i);
            if (i != 0) {
                s.append(", ");
            }
            Type<?> parameterType = p.getParameterType();
            while (parameterType.isWildcardType()) {
                parameterType = parameterType.getExtendsBound();
            }
            if (parameterType.isGenericParameter()) {
                s.append(parameterType.getName());
                continue;
            }
            s = parameterType.appendSimpleDescription(s);
        }
        s.append(')');
        TypeList thrownTypes = this.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            s.append(" throws ");
            int n2 = thrownTypes.size();
            for (int i = 0; i < n2; ++i) {
                Type t = (Type)thrownTypes.get(i);
                if (i != 0) {
                    s.append(", ");
                }
                s = t.appendBriefDescription(s);
            }
        }
        return s;
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        StringBuilder s = new StringBuilder();
        this.appendModifiers(s, this.getModifiers());
        if (this.isGenericMethodDefinition()) {
            TypeList genericParameters = this.getGenericMethodParameters();
            s.append('<');
            int n = genericParameters.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    s.append(", ");
                }
                s = ((Type)genericParameters.get(i)).appendSimpleDescription(s);
            }
            s.append('>');
            s.append(' ');
        }
        Type<?> returnType = this.getReturnType();
        while (returnType.isWildcardType()) {
            returnType = returnType.getExtendsBound();
        }
        if (returnType.isGenericParameter()) {
            s.append(returnType.getName());
        } else {
            s = returnType.appendSimpleDescription(s);
        }
        s.append(' ');
        s.append(this.getName());
        s.append('(');
        ParameterList parameters = this.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterInfo p = (ParameterInfo)parameters.get(i);
            if (i != 0) {
                s.append(", ");
            }
            Type<?> parameterType = p.getParameterType();
            while (parameterType.isWildcardType()) {
                parameterType = parameterType.getExtendsBound();
            }
            if (parameterType.isGenericParameter()) {
                s.append(parameterType.getName());
                continue;
            }
            s = parameterType.appendSimpleDescription(s);
        }
        s.append(')');
        TypeList thrownTypes = this.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            s.append(" throws ");
            int n2 = thrownTypes.size();
            for (int i = 0; i < n2; ++i) {
                Type t = (Type)thrownTypes.get(i);
                if (i != 0) {
                    s.append(", ");
                }
                s = t.appendSimpleDescription(s);
            }
        }
        return s;
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        StringBuilder s = new StringBuilder();
        Type<?> returnType = this.getReturnType();
        while (returnType.isWildcardType()) {
            returnType = returnType.getExtendsBound();
        }
        if (returnType.isGenericParameter()) {
            s.append(returnType.getName());
        } else {
            s = returnType.appendBriefDescription(s);
        }
        s.append(' ');
        s.append(this.getName());
        s.append('(');
        ParameterList parameters = this.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterInfo p = (ParameterInfo)parameters.get(i);
            if (i != 0) {
                s.append(", ");
            }
            Type<?> parameterType = p.getParameterType();
            while (parameterType.isWildcardType()) {
                parameterType = parameterType.getExtendsBound();
            }
            if (parameterType.isGenericParameter()) {
                s.append(parameterType.getName());
                continue;
            }
            s = parameterType.appendBriefDescription(s);
        }
        s.append(')');
        return s;
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        if (this.isGenericMethod() && !this.isGenericMethodDefinition()) {
            return this.getGenericMethodDefinition().appendErasedDescription(sb);
        }
        this.appendModifiers(sb, this.getModifiers());
        TypeList parameterTypes = this.getParameters().getParameterTypes();
        StringBuilder s = this.getReturnType().appendErasedDescription(sb);
        s.append(' ');
        s.append(this.getName());
        s.append('(');
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s = ((Type)parameterTypes.get(i)).appendErasedDescription(s);
        }
        s.append(')');
        return s;
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        TypeList typeArguments;
        int count;
        StringBuilder s = sb;
        if (this.isGenericMethod() && (count = (typeArguments = this.getTypeBindings().getBoundTypes()).size()) > 0) {
            s.append('<');
            for (int i = 0; i < count; ++i) {
                Type type = (Type)typeArguments.get(i);
                s = type.appendGenericSignature(s);
            }
            s.append('>');
        }
        ParameterList parameters = this.getParameters();
        s.append('(');
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterInfo p = (ParameterInfo)parameters.get(i);
            s = p.getParameterType().appendSignature(s);
        }
        s.append(')');
        s = this.getReturnType().appendSignature(s);
        return s;
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        StringBuilder s = sb;
        s.append('(');
        TypeList parameterTypes = this.getParameters().getParameterTypes();
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            s = ((Type)parameterTypes.get(i)).appendErasedSignature(s);
        }
        s.append(')');
        s = this.getReturnType().appendErasedSignature(s);
        return s;
    }

    public boolean isGenericMethod() {
        return !this.getGenericMethodParameters().isEmpty();
    }

    public boolean isGenericMethodDefinition() {
        if (!this.isGenericMethod()) {
            return false;
        }
        TypeBindings typeArguments = this.getTypeBindings();
        return !typeArguments.isEmpty() && !typeArguments.hasBoundParameters();
    }

    protected TypeBindings getTypeBindings() {
        return TypeBindings.empty();
    }

    public TypeList getTypeArguments() {
        return this.getTypeBindings().getBoundTypes();
    }

    public TypeList getGenericMethodParameters() {
        return this.getTypeBindings().getGenericParameters();
    }

    public MethodInfo getGenericMethodDefinition() {
        if (this.isGenericMethod()) {
            if (this.isGenericMethodDefinition()) {
                return this;
            }
            throw ContractUtils.unreachable();
        }
        throw Error.notGenericMethod(this);
    }

    public MethodInfo getErasedMethodDefinition() {
        if (this._erasedMethodDefinition != null) {
            return this._erasedMethodDefinition;
        }
        Type<?> declaringType = this.getDeclaringType();
        Type<?> actualDeclaringType = declaringType.isGenericType() ? declaringType.getErasedType() : declaringType;
        this._erasedMethodDefinition = ErasedType.GenericEraser.visitMethod(actualDeclaringType, this.isGenericMethod() ? this.getGenericMethodDefinition() : this, this.getTypeBindings());
        return this._erasedMethodDefinition;
    }

    public boolean containsGenericParameters() {
        if (this.getReturnType().containsGenericParameters()) {
            return true;
        }
        ParameterList parameters = this.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterInfo parameter = (ParameterInfo)parameters.get(i);
            if (!parameter.getParameterType().containsGenericParameters()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsGenericParameter(Type<?> genericParameter) {
        if (!((Type)VerifyArgument.notNull(genericParameter, (String)"genericParameter")).isGenericParameter()) {
            throw Error.notGenericParameter(genericParameter);
        }
        if (this.isGenericMethodDefinition()) {
            Iterator iterator = this.getGenericMethodParameters().iterator();
            while (iterator.hasNext()) {
                Type gp = (Type)iterator.next();
                if (!gp.containsGenericParameter(genericParameter)) continue;
                return true;
            }
        }
        return false;
    }

    public MethodInfo makeGenericMethod(Type<?> ... typeArguments) {
        return this.makeGenericMethod(Type.list((Type[])VerifyArgument.noNullElements((Object[])typeArguments, (String)"typeArguments")));
    }

    public MethodInfo makeGenericMethod(TypeList typeArguments) {
        if (!this.isGenericMethodDefinition()) {
            throw Error.notGenericMethodDefinition(this);
        }
        TypeBindings bindings = TypeBindings.create(this.getGenericMethodParameters(), typeArguments);
        if (!bindings.hasBoundParameters()) {
            throw new IllegalArgumentException("At least one generic parameter must be bound.");
        }
        return new GenericMethod(bindings, this);
    }

    static MethodInfo reflectedOn(MethodInfo method, Type<?> reflectedType) {
        if (TypeUtils.areEquivalent(reflectedType, method.getReflectedType())) {
            return method;
        }
        return new DelegatingMethodInfo(method, reflectedType);
    }

    static MethodInfo declaredOn(MethodInfo method, Type<?> declaringType, Type<?> reflectedType) {
        if (TypeUtils.areEquivalent(declaringType, method.getDeclaringType()) && TypeUtils.areEquivalent(reflectedType, method.getReflectedType())) {
            return method;
        }
        return new DelegatingMethodInfo(method, declaringType, reflectedType);
    }
}

