/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

final class ErasedField
extends FieldInfo {
    private final FieldInfo _baseField;
    private final Type<?> _declaringType;
    private final Type<?> _fieldType;

    ErasedField(FieldInfo baseField, Type<?> declaringType, Type<?> fieldType) {
        this._baseField = (FieldInfo)VerifyArgument.notNull((Object)baseField, (String)"baseField");
        this._declaringType = (Type)VerifyArgument.notNull(declaringType, (String)"declaringType");
        this._fieldType = (Type)VerifyArgument.notNull(fieldType, (String)"fieldType");
    }

    @Override
    public Type<?> getFieldType() {
        return this._fieldType;
    }

    @Override
    public boolean isEnumConstant() {
        return false;
    }

    @Override
    public Field getRawField() {
        return this._baseField.getRawField();
    }

    @Override
    public String getName() {
        return this._baseField.getName();
    }

    @Override
    public Type<?> getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public Type<?> getReflectedType() {
        return this._baseField.getReflectedType();
    }

    @Override
    public int getModifiers() {
        return this._baseField.getModifiers();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._baseField.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this._baseField.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this._baseField.getDeclaredAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._baseField.isAnnotationPresent(annotationClass);
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        return this._baseField.appendErasedDescription(sb);
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return this._baseField.appendErasedSignature(sb);
    }
}

