/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.input.data.impl;

import jadx.api.plugins.input.ICodeLoader;
import jadx.api.plugins.input.data.IClassData;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class MergeCodeLoader
implements ICodeLoader {
    private final List<ICodeLoader> codeLoaders;
    @Nullable
    private final Closeable closeable;

    public MergeCodeLoader(List<ICodeLoader> codeLoaders) {
        this(codeLoaders, null);
    }

    public MergeCodeLoader(List<ICodeLoader> codeLoaders, @Nullable Closeable closeable) {
        this.codeLoaders = codeLoaders;
        this.closeable = closeable;
    }

    @Override
    public void visitClasses(Consumer<IClassData> consumer) {
        for (ICodeLoader codeLoader : this.codeLoaders) {
            codeLoader.visitClasses(consumer);
        }
    }

    @Override
    public boolean isEmpty() {
        for (ICodeLoader codeLoader : this.codeLoaders) {
            if (codeLoader.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        for (ICodeLoader codeLoader : this.codeLoaders) {
            codeLoader.close();
        }
        if (this.closeable != null) {
            this.closeable.close();
        }
    }
}

