/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.util.collections.fixed;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.vineflower.java.decompiler.modules.decompiler.ValidationHelper;
import org.vineflower.java.decompiler.util.collections.fixed.FastFixedSet;
import org.vineflower.java.decompiler.util.collections.fixed.FastFixedSetFactory;

final class ShortFastFixedSetFactory<E>
extends FastFixedSetFactory<E> {
    private final Map<E, Long> masks = new LinkedHashMap<E, Long>();
    private final long full;

    ShortFastFixedSetFactory(Collection<E> set) {
        ValidationHelper.assertTrue(set.size() <= 64, "Short fast fixed set can't contain more than 64 elements");
        long mask = 1L;
        for (E element : set) {
            this.masks.put(element, mask);
            mask <<= 1;
        }
        this.full = mask - 1L;
    }

    @Override
    public FastFixedSet<E> spawnEmptySet() {
        return new ShortFastFixedSet();
    }

    @Override
    public Collection<? extends E> getEntries() {
        return this.masks.keySet();
    }

    public final class ShortFastFixedSet
    extends FastFixedSet<E> {
        private long data;

        private ShortFastFixedSet() {
            super(ShortFastFixedSetFactory.this);
            this.data = 0L;
        }

        private ShortFastFixedSet(long data) {
            super(ShortFastFixedSetFactory.this);
            this.data = 0L;
            this.data = data;
        }

        @Override
        public FastFixedSet<E> clone() {
            return new ShortFastFixedSet(this.data);
        }

        @Override
        public void setAllElements() {
            this.data = ShortFastFixedSetFactory.this.full;
        }

        @Override
        public boolean add(E element) {
            long mask = ShortFastFixedSetFactory.this.masks.get(element);
            return (this.data |= mask) != this.data;
        }

        @Override
        public void clear() {
            this.data = 0L;
        }

        @Override
        public boolean remove(Object element) {
            long mask = ShortFastFixedSetFactory.this.masks.get(element);
            return (this.data &= mask ^ 0xFFFFFFFFFFFFFFFFL) != this.data;
        }

        @Override
        public boolean contains(Object element) {
            long mask = ShortFastFixedSetFactory.this.masks.get(element);
            return (this.data & mask) != 0L;
        }

        @Override
        public boolean containsAll(FastFixedSet<E> set) {
            return (this.getData(set) & (this.data ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
        }

        private long getData(FastFixedSet<E> set) {
            assert (set.factory == ShortFastFixedSetFactory.this);
            return ((ShortFastFixedSet)set).data;
        }

        @Override
        public boolean addAll(FastFixedSet<E> set) {
            return (this.data |= this.getData(set)) != this.data;
        }

        @Override
        public boolean retainAll(FastFixedSet<E> set) {
            return (this.data &= this.getData(set)) != this.data;
        }

        @Override
        public boolean removeAll(FastFixedSet<E> set) {
            return (this.data &= this.getData(set) ^ 0xFFFFFFFFFFFFFFFFL) != this.data;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShortFastFixedSet that = (ShortFastFixedSet)o;
            return ShortFastFixedSetFactory.this == that.factory && this.data == that.data;
        }

        @Override
        public int hashCode() {
            return 31 * ShortFastFixedSetFactory.this.hashCode() + Long.hashCode(this.data);
        }

        @Override
        public int getRealSize() {
            return Long.bitCount(this.data);
        }

        @Override
        public boolean isEmpty() {
            return this.data == 0L;
        }

        @Override
        public Iterator<E> iterator() {
            return new LongFastFixedSetIterator();
        }

        @Override
        public String toString() {
            StringJoiner buffer = new StringJoiner(",", "{", "}");
            long data = this.data;
            ShortFastFixedSetFactory.this.masks.forEach((? super K item, ? super V mask) -> {
                if ((data & mask) != 0L) {
                    buffer.add(item.toString());
                }
            });
            return buffer.toString();
        }

        private final class LongFastFixedSetIterator
        implements Iterator<E> {
            private final Iterator<Map.Entry<E, Long>> data;
            private Map.Entry<E, Long> entry;
            private Map.Entry<E, Long> lastEntry;

            private LongFastFixedSetIterator() {
                this.data = ShortFastFixedSetFactory.this.masks.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.data.hasNext()) {
                    this.entry = this.data.next();
                    long mask = this.entry.getValue();
                    if ((ShortFastFixedSet.this.data & mask) == 0L) continue;
                    return true;
                }
                this.entry = null;
                return false;
            }

            @Override
            public E next() {
                if (this.entry == null && !this.hasNext()) {
                    ValidationHelper.validateTrue(false, "No more elements");
                    return null;
                }
                ValidationHelper.notNull(this.entry);
                this.lastEntry = this.entry;
                this.entry = null;
                return this.lastEntry.getKey();
            }

            @Override
            public void remove() {
                long mask = this.lastEntry.getValue();
                ShortFastFixedSet.this.data &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
    }
}

