/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.util.collections.fixed;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.vineflower.java.decompiler.modules.decompiler.ValidationHelper;
import org.vineflower.java.decompiler.util.collections.fixed.FastFixedSet;
import org.vineflower.java.decompiler.util.collections.fixed.FastFixedSetFactory;

class LongFastFixedSetFactory<E>
extends FastFixedSetFactory<E> {
    private final Map<E, Integer> indexes = new LinkedHashMap<E, Integer>();
    private final int dataLength;

    LongFastFixedSetFactory(Collection<E> set) {
        this.dataLength = set.size() + 63 >> 6;
        int index = 0;
        for (E element : set) {
            this.indexes.put(element, index++);
        }
    }

    @Override
    public FastFixedSet<E> spawnEmptySet() {
        return new LongFastFixedSet();
    }

    @Override
    public Collection<? extends E> getEntries() {
        return this.indexes.keySet();
    }

    public final class LongFastFixedSet
    extends FastFixedSet<E> {
        private final long[] data;

        private LongFastFixedSet() {
            super(LongFastFixedSetFactory.this);
            this.data = new long[LongFastFixedSetFactory.this.dataLength];
        }

        private LongFastFixedSet(long[] data) {
            super(LongFastFixedSetFactory.this);
            this.data = data;
        }

        @Override
        public FastFixedSet<E> clone() {
            return new LongFastFixedSet((long[])this.data.clone());
        }

        @Override
        public void setAllElements() {
            this.data[this.data.length - 1] = (2L << (LongFastFixedSetFactory.this.indexes.size() & 0x3F) - 1) - 1L;
            Arrays.fill(this.data, 0, this.data.length - 1, -1L);
        }

        @Override
        public boolean add(E element) {
            int index = LongFastFixedSetFactory.this.indexes.get(element);
            int n = index >> 6;
            long l = this.data[n] | 1L << (index & 0x3F);
            this.data[n] = l;
            return this.data[index >> 6] != l;
        }

        @Override
        public void clear() {
            Arrays.fill(this.data, 0L);
        }

        @Override
        public boolean remove(Object element) {
            int index = LongFastFixedSetFactory.this.indexes.get(element);
            int n = index >> 6;
            long l = this.data[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            this.data[n] = l;
            return this.data[index >> 6] != l;
        }

        @Override
        public boolean contains(Object element) {
            int index = LongFastFixedSetFactory.this.indexes.get(element);
            return (this.data[index >> 6] & 1L << (index & 0x3F)) != 0L;
        }

        @Override
        public boolean containsAll(FastFixedSet<E> set) {
            long[] intdata = this.data;
            long[] extdata = this.getData(set);
            for (int i = intdata.length - 1; i >= 0; --i) {
                if ((extdata[i] & (intdata[i] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
                return false;
            }
            return true;
        }

        private long[] getData(FastFixedSet<E> set) {
            ValidationHelper.validateTrue(set.factory == LongFastFixedSetFactory.this, "Incompatible set factories");
            return ((LongFastFixedSet)set).data;
        }

        @Override
        public boolean addAll(FastFixedSet<E> set) {
            long[] intdata = this.data;
            long[] extdata = this.getData(set);
            boolean mutated = false;
            for (int i = intdata.length - 1; i >= 0; --i) {
                int n = i;
                long l = intdata[n] | extdata[i];
                intdata[n] = l;
                mutated |= intdata[i] != l;
            }
            return mutated;
        }

        @Override
        public boolean retainAll(FastFixedSet<E> set) {
            long[] intdata = this.data;
            long[] extdata = this.getData(set);
            boolean mutated = false;
            for (int i = intdata.length - 1; i >= 0; --i) {
                int n = i;
                long l = intdata[n] & extdata[i];
                intdata[n] = l;
                mutated |= intdata[i] != l;
            }
            return mutated;
        }

        @Override
        public boolean removeAll(FastFixedSet<E> set) {
            long[] intdata = this.data;
            long[] extdata = this.getData(set);
            boolean mutated = false;
            for (int i = intdata.length - 1; i >= 0; --i) {
                int n = i;
                long l = intdata[n] & (extdata[i] ^ 0xFFFFFFFFFFFFFFFFL);
                intdata[n] = l;
                mutated |= intdata[i] != l;
            }
            return mutated;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongFastFixedSet that = (LongFastFixedSet)o;
            return LongFastFixedSetFactory.this == that.factory && Arrays.equals(this.data, that.data);
        }

        @Override
        public int hashCode() {
            return 31 * LongFastFixedSetFactory.this.hashCode() + Arrays.hashCode(this.data);
        }

        @Override
        public int getRealSize() {
            int size = 0;
            for (long d : this.data) {
                size += Long.bitCount(d);
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            for (long d : this.data) {
                if (d == 0L) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return new LongFastFixedSetIterator();
        }

        @Override
        public String toString() {
            StringJoiner buffer = new StringJoiner(",", "{", "}");
            long[] data = this.data;
            LongFastFixedSetFactory.this.indexes.forEach((? super K item, ? super V i) -> {
                if ((data[i >> 6] & 1L << (i & 0x3F)) != 0L) {
                    buffer.add(item.toString());
                }
            });
            return buffer.toString();
        }

        private final class LongFastFixedSetIterator
        implements Iterator<E> {
            private final Iterator<Map.Entry<E, Integer>> data;
            private Map.Entry<E, Integer> entry;
            private Map.Entry<E, Integer> lastEntry;

            private LongFastFixedSetIterator() {
                this.data = LongFastFixedSetFactory.this.indexes.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.data.hasNext()) {
                    this.entry = this.data.next();
                    int index = this.entry.getValue();
                    if ((LongFastFixedSet.this.data[index >> 6] & 1L << (index & 0x3F)) == 0L) continue;
                    return true;
                }
                this.entry = null;
                return false;
            }

            @Override
            public E next() {
                if (this.entry == null && !this.hasNext()) {
                    ValidationHelper.validateTrue(false, "No more elements");
                    return null;
                }
                ValidationHelper.notNull(this.entry);
                this.lastEntry = this.entry;
                this.entry = null;
                return this.lastEntry.getKey();
            }

            @Override
            public void remove() {
                int index = this.lastEntry.getValue();
                int n = index >> 6;
                LongFastFixedSet.this.data[n] = LongFastFixedSet.this.data[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }
}

