/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.extern.IContextSource;
import org.vineflower.java.decompiler.main.extern.IFernflowerLogger;
import org.vineflower.java.decompiler.struct.StructClass;
import org.vineflower.java.decompiler.struct.StructContext;
import org.vineflower.java.decompiler.struct.attr.StructGeneralAttribute;
import org.vineflower.java.decompiler.struct.attr.StructModuleAttribute;
import org.vineflower.java.decompiler.util.DataInputFullStream;
import org.vineflower.java.decompiler.util.ModuleBasedContextSource;

public class JrtFinder {
    public static final String CURRENT = "current";

    public static void addRuntime(StructContext ctx) {
        try {
            ctx.addSpace(new JavaRuntimeContextSource(null), false);
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Failed to open current java runtime for inspection", ex);
        }
    }

    public static void addRuntime(StructContext ctx, File javaHome) {
        if (new File(javaHome, "lib/jrt-fs.jar").isFile()) {
            try {
                ctx.addSpace(new JavaRuntimeContextSource(javaHome), false);
            }
            catch (IOException ex) {
                DecompilerContext.getLogger().writeMessage("Failed to open java runtime at " + String.valueOf(javaHome), ex);
            }
            return;
        }
        if (javaHome.exists()) {
            boolean anyAdded = false;
            ArrayList jrt = new ArrayList();
            Collections.addAll(jrt, new File(javaHome, "jre/lib").listFiles());
            Collections.addAll(jrt, new File(javaHome, "lib").listFiles());
            for (File lib : jrt) {
                if (!lib.isFile() || !lib.getName().endsWith(".jar")) continue;
                ctx.addSpace(lib, false);
                anyAdded = true;
            }
            if (anyAdded) {
                return;
            }
        }
        DecompilerContext.getLogger().writeMessage("Unable to detect a java runtime at " + String.valueOf(javaHome), IFernflowerLogger.Severity.ERROR);
    }

    static final class JavaRuntimeContextSource
    implements IContextSource,
    AutoCloseable {
        private final String identifier;
        private final FileSystem jrtFileSystem;

        public JavaRuntimeContextSource(File javaHome) throws IOException {
            URI url = URI.create("jrt:/");
            if (javaHome == null) {
                this.identifier = JrtFinder.CURRENT;
                this.jrtFileSystem = FileSystems.newFileSystem(url, Map.of());
            } else {
                this.identifier = javaHome.getAbsolutePath();
                this.jrtFileSystem = FileSystems.newFileSystem(url, Map.of("java.home", javaHome.getAbsolutePath()));
            }
        }

        @Override
        public String getName() {
            return "Java runtime " + this.identifier;
        }

        @Override
        public IContextSource.Entries getEntries() {
            ArrayList<IContextSource> children = new ArrayList<IContextSource>();
            try {
                List modules = Files.list(this.jrtFileSystem.getPath("modules", new String[0])).collect(Collectors.toList());
                for (Path module : modules) {
                    ModuleDescriptor descriptor;
                    block11: {
                        try {
                            InputStream is = Files.newInputStream(module.resolve("module-info.class"), new OpenOption[0]);
                            try {
                                StructClass clazz = StructClass.create(new DataInputFullStream(is.readAllBytes()), false);
                                StructModuleAttribute moduleAttr = clazz.getAttribute(StructGeneralAttribute.ATTRIBUTE_MODULE);
                                if (moduleAttr == null) continue;
                                descriptor = moduleAttr.asDescriptor();
                                break block11;
                            }
                            finally {
                                if (is == null) continue;
                                is.close();
                            }
                        }
                        catch (IOException ex) {}
                        continue;
                    }
                    children.add(new JavaRuntimeModuleContextSource(descriptor, module));
                }
                return new IContextSource.Entries(List.of(), List.of(), List.of(), children);
            }
            catch (IOException ex) {
                DecompilerContext.getLogger().writeMessage("Failed to read modules from runtime " + this.identifier, ex);
                return IContextSource.Entries.EMPTY;
            }
        }

        @Override
        public InputStream getInputStream(String resource) throws IOException {
            return null;
        }

        @Override
        public void close() throws IOException {
            this.jrtFileSystem.close();
        }
    }

    static final class JavaRuntimeModuleContextSource
    extends ModuleBasedContextSource {
        private Path module;

        JavaRuntimeModuleContextSource(ModuleDescriptor descriptor, Path moduleRoot) {
            super(descriptor);
            this.module = moduleRoot;
        }

        @Override
        public InputStream getInputStream(String resource) throws IOException {
            return Files.newInputStream(this.module.resolve(resource), new OpenOption[0]);
        }

        @Override
        protected Stream<String> entryNames() throws IOException {
            try (Stream<Path> dir = Files.walk(this.module, new FileVisitOption[0]);){
                Stream<String> stream = dir.map(it -> this.module.relativize((Path)it).toString()).collect(Collectors.toList()).stream();
                return stream;
            }
        }
    }
}

