/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.struct.match;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.vineflower.java.decompiler.struct.match.IMatchable;

public class MatchNode {
    public static final int MATCHNODE_STATEMENT = 0;
    public static final int MATCHNODE_EXPRENT = 1;
    private final int type;
    private final Map<IMatchable.MatchProperties, List<RuleValue>> rules = new HashMap<IMatchable.MatchProperties, List<RuleValue>>();
    private final List<MatchNode> children = new ArrayList<MatchNode>();

    public MatchNode(int type) {
        this.type = type;
    }

    public void addChild(MatchNode child) {
        this.children.add(child);
    }

    public void addRule(IMatchable.MatchProperties property, RuleValue value) {
        this.rules.computeIfAbsent(property, k -> new ArrayList()).add(value);
    }

    public int getType() {
        return this.type;
    }

    public List<MatchNode> getChildren() {
        return this.children;
    }

    public boolean iterateRules(BiFunction<IMatchable.MatchProperties, RuleValue, Boolean> consumer) {
        for (Map.Entry<IMatchable.MatchProperties, List<RuleValue>> e : this.rules.entrySet()) {
            for (RuleValue rule : e.getValue()) {
                if (consumer.apply(e.getKey(), rule).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public RuleValue getRawRule(IMatchable.MatchProperties property) {
        List<RuleValue> list = this.rules.get((Object)property);
        return list != null ? list.get(0) : null;
    }

    public Object getRuleValue(IMatchable.MatchProperties property) {
        List<RuleValue> rule = this.rules.get((Object)property);
        return rule == null ? null : rule.get((int)0).value;
    }

    public static class RuleValue {
        public final int parameter;
        public final Object value;

        public RuleValue(int parameter, Object value) {
            this.parameter = parameter;
            this.value = value;
        }

        public boolean isVariable() {
            String strValue = this.value.toString();
            return strValue.charAt(0) == '$' && strValue.charAt(strValue.length() - 1) == '$';
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

