/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.struct.match;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.vineflower.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.struct.gen.VarType;
import org.vineflower.java.decompiler.struct.match.IMatchable;
import org.vineflower.java.decompiler.struct.match.MatchNode;

public class MatchEngine {
    private static final Map<String, IMatchable.MatchProperties> stat_properties = new HashMap<String, IMatchable.MatchProperties>();
    private static final Map<String, IMatchable.MatchProperties> expr_properties = new HashMap<String, IMatchable.MatchProperties>();
    private static final Map<String, Statement.StatementType> stat_type = new HashMap<String, Statement.StatementType>();
    private static final Map<String, Exprent.Type> expr_type = new HashMap<String, Exprent.Type>();
    private static final Map<String, FunctionExprent.FunctionType> expr_func_type = new HashMap<String, FunctionExprent.FunctionType>();
    private static final Map<String, ExitExprent.Type> expr_exit_type = new HashMap<String, ExitExprent.Type>();
    private static final Map<String, Integer> stat_if_type = new HashMap<String, Integer>();
    private static final Map<String, VarType> expr_const_type = new HashMap<String, VarType>();
    private final MatchNode rootNode;
    private final ThreadLocal<Map<String, Object>> variables;

    public MatchEngine(String ... description) {
        this(String.join((CharSequence)"\n", description));
    }

    /*
     * Exception decompiling
     */
    public MatchEngine(String description) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:67)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.AbstractStructuredBlockStatement.transformStructuredChildren(AbstractStructuredBlockStatement.java:28)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean match(IMatchable object) {
        this.variables.get().clear();
        return this.match(this.rootNode, object);
    }

    private boolean match(MatchNode matchNode, IMatchable object) {
        if (!object.match(matchNode, this)) {
            return false;
        }
        int expr_index = 0;
        int stat_index = 0;
        Iterator<MatchNode> iterator = matchNode.getChildren().iterator();
        while (iterator.hasNext()) {
            MatchNode childNode;
            boolean isStatement = (childNode = iterator.next()).getType() == 0;
            IMatchable childObject = object.findObject(childNode, isStatement ? stat_index : expr_index);
            if (childObject == null || !this.match(childNode, childObject)) {
                return false;
            }
            if (isStatement) {
                ++stat_index;
                continue;
            }
            ++expr_index;
        }
        return true;
    }

    public boolean checkAndSetVariableValue(String name, Object value) {
        Object old_value = this.variables.get().get(name);
        if (old_value != null) {
            return old_value.equals(value);
        }
        this.variables.get().put(name, value);
        return true;
    }

    public Object getVariableValue(String name) {
        return this.variables.get().get(name);
    }

    static {
        stat_properties.put("type", IMatchable.MatchProperties.STATEMENT_TYPE);
        stat_properties.put("ret", IMatchable.MatchProperties.STATEMENT_RET);
        stat_properties.put("position", IMatchable.MatchProperties.STATEMENT_POSITION);
        stat_properties.put("statsize", IMatchable.MatchProperties.STATEMENT_STATSIZE);
        stat_properties.put("exprsize", IMatchable.MatchProperties.STATEMENT_EXPRSIZE);
        stat_properties.put("iftype", IMatchable.MatchProperties.STATEMENT_IFTYPE);
        expr_properties.put("type", IMatchable.MatchProperties.EXPRENT_TYPE);
        expr_properties.put("ret", IMatchable.MatchProperties.EXPRENT_RET);
        expr_properties.put("position", IMatchable.MatchProperties.EXPRENT_POSITION);
        expr_properties.put("functype", IMatchable.MatchProperties.EXPRENT_FUNCTYPE);
        expr_properties.put("exittype", IMatchable.MatchProperties.EXPRENT_EXITTYPE);
        expr_properties.put("consttype", IMatchable.MatchProperties.EXPRENT_CONSTTYPE);
        expr_properties.put("constvalue", IMatchable.MatchProperties.EXPRENT_CONSTVALUE);
        expr_properties.put("invclass", IMatchable.MatchProperties.EXPRENT_INVOCATION_CLASS);
        expr_properties.put("signature", IMatchable.MatchProperties.EXPRENT_INVOCATION_SIGNATURE);
        expr_properties.put("parameter", IMatchable.MatchProperties.EXPRENT_PARAMETER);
        expr_properties.put("index", IMatchable.MatchProperties.EXPRENT_VAR_INDEX);
        expr_properties.put("name", IMatchable.MatchProperties.EXPRENT_NAME);
        stat_type.put("if", Statement.StatementType.IF);
        stat_type.put("do", Statement.StatementType.DO);
        stat_type.put("switch", Statement.StatementType.SWITCH);
        stat_type.put("trycatch", Statement.StatementType.TRY_CATCH);
        stat_type.put("basicblock", Statement.StatementType.BASIC_BLOCK);
        stat_type.put("sequence", Statement.StatementType.SEQUENCE);
        expr_type.put("annotation", Exprent.Type.ANNOTATION);
        expr_type.put("array", Exprent.Type.ARRAY);
        expr_type.put("assert", Exprent.Type.ASSERT);
        expr_type.put("assignment", Exprent.Type.ASSIGNMENT);
        expr_type.put("constant", Exprent.Type.CONST);
        expr_type.put("exit", Exprent.Type.EXIT);
        expr_type.put("field", Exprent.Type.FIELD);
        expr_type.put("function", Exprent.Type.FUNCTION);
        expr_type.put("if", Exprent.Type.IF);
        expr_type.put("invocation", Exprent.Type.INVOCATION);
        expr_type.put("monitor", Exprent.Type.MONITOR);
        expr_type.put("new", Exprent.Type.NEW);
        expr_type.put("switch", Exprent.Type.SWITCH);
        expr_type.put("switchhead", Exprent.Type.SWITCH_HEAD);
        expr_type.put("var", Exprent.Type.VAR);
        expr_type.put("yield", Exprent.Type.YIELD);
        expr_func_type.put("eq", FunctionExprent.FunctionType.EQ);
        expr_func_type.put("neq", FunctionExprent.FunctionType.NE);
        expr_func_type.put("ternary", FunctionExprent.FunctionType.TERNARY);
        expr_exit_type.put("return", ExitExprent.Type.RETURN);
        expr_exit_type.put("throw", ExitExprent.Type.THROW);
        stat_if_type.put("if", 0);
        stat_if_type.put("ifelse", 1);
        expr_const_type.put("null", VarType.VARTYPE_NULL);
        expr_const_type.put("string", VarType.VARTYPE_STRING);
    }
}

