/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.struct.attr;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.vineflower.java.decompiler.code.BytecodeVersion;
import org.vineflower.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.TypeAnnotation;
import org.vineflower.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.vineflower.java.decompiler.struct.attr.StructGeneralAttribute;
import org.vineflower.java.decompiler.struct.consts.ConstantPool;
import org.vineflower.java.decompiler.util.DataInputFullStream;

public class StructTypeAnnotationAttribute
extends StructGeneralAttribute {
    private List<TypeAnnotation> annotations = Collections.emptyList();

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool, BytecodeVersion version) throws IOException {
        int len = data.readUnsignedShort();
        if (len > 0) {
            this.annotations = new ArrayList<TypeAnnotation>(len);
            for (int i = 0; i < len; ++i) {
                this.annotations.add(StructTypeAnnotationAttribute.parse(data, pool));
            }
        } else {
            this.annotations = Collections.emptyList();
        }
    }

    private static TypeAnnotation parse(DataInputStream data, ConstantPool pool) throws IOException {
        int targetType = data.readUnsignedByte();
        int target = targetType << 24;
        switch (targetType) {
            case 0: 
            case 1: 
            case 22: {
                target |= data.readUnsignedByte();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                target |= data.readUnsignedShort();
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                data.skipBytes(3);
                break;
            }
            case 64: 
            case 65: {
                data.skipBytes(data.readUnsignedShort() * 6);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            default: {
                throw new RuntimeException("unknown target type: " + targetType);
            }
        }
        int pathLength = data.readUnsignedByte();
        byte[] path = null;
        if (pathLength > 0) {
            path = new byte[2 * pathLength];
            data.readFully(path);
        }
        AnnotationExprent annotation = StructAnnotationAttribute.parseAnnotation(data, pool);
        return new TypeAnnotation(target, path, annotation);
    }

    public List<TypeAnnotation> getAnnotations() {
        return this.annotations;
    }
}

