/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.struct.attr;

import java.io.IOException;
import org.vineflower.java.decompiler.code.BytecodeVersion;
import org.vineflower.java.decompiler.struct.attr.StructGeneralAttribute;
import org.vineflower.java.decompiler.struct.consts.ConstantPool;
import org.vineflower.java.decompiler.util.DataInputFullStream;
import org.vineflower.java.decompiler.util.InterpreterUtil;

public class StructLineNumberTableAttribute
extends StructGeneralAttribute {
    private int[] myLineInfo = InterpreterUtil.EMPTY_INT_ARRAY;

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool, BytecodeVersion version) throws IOException {
        int len = data.readUnsignedShort() * 2;
        if (len > 0) {
            this.myLineInfo = new int[len];
            for (int i = 0; i < len; i += 2) {
                this.myLineInfo[i] = data.readUnsignedShort();
                this.myLineInfo[i + 1] = data.readUnsignedShort();
            }
        } else if (this.myLineInfo.length > 0) {
            this.myLineInfo = InterpreterUtil.EMPTY_INT_ARRAY;
        }
    }

    public int findLineNumber(int pc) {
        if (this.myLineInfo.length >= 2) {
            for (int i = this.myLineInfo.length - 2; i >= 0; i -= 2) {
                if (pc < this.myLineInfo[i]) continue;
                return this.myLineInfo[i + 1];
            }
        }
        return -1;
    }

    public int[] getRawData() {
        return this.myLineInfo;
    }
}

