/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.struct.attr;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.vineflower.java.decompiler.code.BytecodeVersion;
import org.vineflower.java.decompiler.struct.StructMember;
import org.vineflower.java.decompiler.struct.attr.StructGeneralAttribute;
import org.vineflower.java.decompiler.struct.consts.ConstantPool;
import org.vineflower.java.decompiler.util.DataInputFullStream;

public class StructCodeAttribute
extends StructGeneralAttribute {
    public int localVariables = 0;
    public byte[] codeAndExceptionData;
    public Map<String, StructGeneralAttribute> codeAttributes;

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool, BytecodeVersion version) throws IOException {
        boolean predatesJava = version.predatesJava();
        data.discard(predatesJava ? 1 : 2);
        this.localVariables = predatesJava ? data.readUnsignedByte() : data.readUnsignedShort();
        byte[] codeData = new byte[predatesJava ? data.readUnsignedShort() : data.readInt()];
        data.readFully(codeData);
        int excLength = data.readUnsignedShort();
        byte[] exceptionData = new byte[excLength * 8];
        data.readFully(exceptionData);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(codeData.length + 2 + exceptionData.length);
        DataOutputStream d = new DataOutputStream(baos);
        d.writeInt(codeData.length);
        d.write(codeData);
        d.writeShort(excLength);
        d.write(exceptionData);
        this.codeAndExceptionData = baos.toByteArray();
        this.codeAttributes = StructMember.readAttributes(data, pool, version);
    }
}

