/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.struct;

import java.io.IOException;
import java.util.Map;
import org.vineflower.java.decompiler.code.BytecodeVersion;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.struct.StructField;
import org.vineflower.java.decompiler.struct.attr.StructGeneralAttribute;
import org.vineflower.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.vineflower.java.decompiler.struct.consts.ConstantPool;
import org.vineflower.java.decompiler.struct.consts.PrimitiveConstant;
import org.vineflower.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.vineflower.java.decompiler.struct.gen.generics.GenericMain;
import org.vineflower.java.decompiler.util.DataInputFullStream;

public class StructRecordComponent
extends StructField {
    public static StructRecordComponent create(DataInputFullStream in, ConstantPool pool, BytecodeVersion version) throws IOException {
        StructGenericSignatureAttribute signatureAttr;
        int nameIndex = in.readUnsignedShort();
        int descriptorIndex = in.readUnsignedShort();
        String name = ((PrimitiveConstant)pool.getConstant(nameIndex)).getString();
        String descriptor = ((PrimitiveConstant)pool.getConstant(descriptorIndex)).getString();
        Map<String, StructGeneralAttribute> attributes = StructRecordComponent.readAttributes(in, pool, version);
        GenericFieldDescriptor signature = null;
        if (DecompilerContext.getOption("decompile-generics") && (signatureAttr = (StructGenericSignatureAttribute)attributes.get(StructGeneralAttribute.ATTRIBUTE_SIGNATURE.name)) != null) {
            signature = GenericMain.parseFieldSignature(signatureAttr.getSignature());
        }
        return new StructRecordComponent(0, attributes, name, descriptor, signature, version);
    }

    private StructRecordComponent(int flags, Map<String, StructGeneralAttribute> attributes, String name, String descriptor, GenericFieldDescriptor signature, BytecodeVersion version) {
        super(flags, attributes, name, descriptor, signature, version);
    }
}

