/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.struct;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.extern.IBytecodeProvider;
import org.vineflower.java.decompiler.main.extern.IContextSource;
import org.vineflower.java.decompiler.main.extern.IFernflowerLogger;
import org.vineflower.java.decompiler.main.extern.IResultSaver;

final class JarContextSource
implements IContextSource,
AutoCloseable {
    private final IBytecodeProvider legacyProvider;
    private final String relativePath;
    private final File jarFile;
    private final ZipFile file;

    JarContextSource(IBytecodeProvider legacyProvider, File archive) throws IOException {
        this(legacyProvider, archive, "");
    }

    JarContextSource(IBytecodeProvider legacyProvider, File archive, String relativePath) throws IOException {
        this.legacyProvider = legacyProvider;
        this.relativePath = relativePath;
        this.jarFile = Objects.requireNonNull(archive, "archive");
        this.file = new ZipFile(archive);
    }

    @Override
    public String getName() {
        return "archive " + this.jarFile.getAbsolutePath();
    }

    @Override
    public IContextSource.Entries getEntries() {
        ArrayList<IContextSource.Entry> classes = new ArrayList<IContextSource.Entry>();
        LinkedHashSet<String> directories = new LinkedHashSet<String>();
        ArrayList<IContextSource.Entry> others = new ArrayList<IContextSource.Entry>();
        Enumeration<? extends ZipEntry> entries = this.file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            this.addDirectories(entry, directories);
            if (entry.isDirectory()) continue;
            if (name.endsWith(".class")) {
                classes.add(IContextSource.Entry.parse(name.substring(0, name.length() - ".class".length())));
                continue;
            }
            others.add(IContextSource.Entry.parse(name));
        }
        return new IContextSource.Entries(classes, List.copyOf(directories), others, List.of());
    }

    private void addDirectories(ZipEntry entry, Set<String> directories) {
        String name = entry.getName();
        int segmentIndex = name.indexOf(47);
        while (segmentIndex != -1) {
            directories.add(name.substring(0, segmentIndex));
            segmentIndex = name.indexOf(47, segmentIndex + 1);
        }
        if (entry.isDirectory()) {
            directories.add(name);
        }
    }

    @Override
    public InputStream getInputStream(String resource) throws IOException {
        if (this.legacyProvider != null) {
            return new ByteArrayInputStream(this.legacyProvider.getBytecode(this.jarFile.getAbsolutePath(), resource));
        }
        ZipEntry entry = this.file.getEntry(resource);
        return this.file.getInputStream(entry);
    }

    @Override
    public IContextSource.IOutputSink createOutputSink(final IResultSaver saver) {
        final String archiveName = this.jarFile.getName();
        return new IContextSource.IOutputSink(){

            @Override
            public void begin() {
                ZipEntry potentialManifest = JarContextSource.this.file.getEntry("META-INF/MANIFEST.MF");
                Manifest manifest = null;
                if (potentialManifest != null) {
                    try (InputStream is = JarContextSource.this.file.getInputStream(potentialManifest);){
                        manifest = new Manifest(is);
                    }
                    catch (IOException ex) {
                        DecompilerContext.getLogger().writeMessage("Failed to read manifest from " + String.valueOf(JarContextSource.this.file), IFernflowerLogger.Severity.ERROR, ex);
                    }
                }
                saver.saveFolder(JarContextSource.this.relativePath);
                saver.createArchive(JarContextSource.this.relativePath, archiveName, manifest);
            }

            @Override
            public void acceptOther(String path) {
                saver.copyEntry(JarContextSource.this.jarFile.getAbsolutePath(), JarContextSource.this.relativePath, archiveName, path);
            }

            @Override
            public void acceptDirectory(String directory) {
                saver.saveDirEntry(JarContextSource.this.relativePath, archiveName, directory);
            }

            @Override
            public void acceptClass(String qualifiedName, String fileName, String content, int[] mapping) {
                saver.saveClassEntry(JarContextSource.this.relativePath, JarContextSource.this.jarFile.getName(), qualifiedName, fileName, content, mapping);
            }

            @Override
            public void close() throws IOException {
                saver.closeArchive(JarContextSource.this.relativePath, archiveName);
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

