/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.struct;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.decompiler.ConsoleDecompiler;
import org.vineflower.java.decompiler.main.extern.IBytecodeProvider;
import org.vineflower.java.decompiler.main.extern.IContextSource;
import org.vineflower.java.decompiler.main.extern.IFernflowerLogger;
import org.vineflower.java.decompiler.main.extern.IResultSaver;
import org.vineflower.java.decompiler.struct.JarContextSource;

public class DirectoryContextSource
implements IContextSource {
    private final IBytecodeProvider legacyProvider;
    private final File baseDirectory;

    public DirectoryContextSource(IBytecodeProvider legacyProvider, File baseDirectory) {
        this.legacyProvider = legacyProvider;
        this.baseDirectory = baseDirectory;
    }

    @Override
    public String getName() {
        return "directory " + this.baseDirectory.getAbsolutePath();
    }

    @Override
    public IContextSource.Entries getEntries() {
        ArrayList<IContextSource.Entry> classes = new ArrayList<IContextSource.Entry>();
        ArrayList<String> directories = new ArrayList<String>();
        ArrayList<IContextSource.Entry> others = new ArrayList<IContextSource.Entry>();
        ArrayList<IContextSource> jarChildren = new ArrayList<IContextSource>();
        this.collectEntries(this.baseDirectory.getAbsolutePath(), this.baseDirectory, classes, directories, others, jarChildren);
        return new IContextSource.Entries(classes, directories, others, jarChildren);
    }

    void collectEntries(String base, File current, List<IContextSource.Entry> classes, List<String> directories, List<IContextSource.Entry> others, List<IContextSource> jarChildren) {
        String relativePath = this.relativize(base, current);
        if (current.isDirectory()) {
            File[] children;
            directories.add(relativePath);
            for (File child : children = current.listFiles()) {
                this.collectEntries(base, child, classes, directories, others, jarChildren);
            }
        } else if (relativePath.endsWith(".class")) {
            classes.add(this.sanitize(relativePath.substring(0, relativePath.length() - ".class".length())));
        } else if (relativePath.endsWith(".jar") || relativePath.endsWith(".zip")) {
            String relativeTo = current.getParentFile().getAbsolutePath().substring(base.length());
            try {
                jarChildren.add(new JarContextSource(this.legacyProvider, current, relativeTo));
            }
            catch (IOException ex) {
                String message = "Invalid archive " + String.valueOf(current);
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.ERROR, ex);
                throw new UncheckedIOException(message, ex);
            }
        } else {
            others.add(this.sanitize(relativePath));
        }
    }

    private String relativize(String base, File current) {
        String relativePath = current.getAbsolutePath().substring(base.length());
        return relativePath.startsWith("/") || relativePath.startsWith("\\") ? relativePath.substring(1) : relativePath;
    }

    private IContextSource.Entry sanitize(String path) {
        return IContextSource.Entry.atBase(path.replace(File.separatorChar, '/'));
    }

    @Override
    public InputStream getInputStream(String resource) throws IOException {
        File targetFile = new File(this.baseDirectory, resource);
        if (this.legacyProvider != null) {
            return new ByteArrayInputStream(this.legacyProvider.getBytecode(targetFile.getAbsolutePath(), null));
        }
        return new FileInputStream(targetFile);
    }

    @Override
    public IContextSource.IOutputSink createOutputSink(final IResultSaver saver) {
        final File base = this.baseDirectory;
        final String basePath = this.baseDirectory.getAbsolutePath();
        return new IContextSource.IOutputSink(){

            @Override
            public void begin() {
                if (!(saver instanceof ConsoleDecompiler)) {
                    saver.createArchive(basePath, "", null);
                }
                saver.saveFolder("");
            }

            @Override
            public void acceptOther(String path) {
                saver.copyFile(new File(base, path).getAbsolutePath(), "", path);
            }

            @Override
            public void acceptDirectory(String directory) {
                saver.saveFolder(directory);
            }

            @Override
            public void acceptClass(String qualifiedName, String fileName, String content, int[] mapping) {
                saver.saveClassFile("", qualifiedName, fileName, content, mapping);
            }

            @Override
            public void close() throws IOException {
                saver.closeArchive("", base.getName() + ".jar");
            }
        };
    }
}

