/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler.vars;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.vineflower.java.decompiler.modules.decompiler.ValidationHelper;
import org.vineflower.java.decompiler.modules.decompiler.decompose.GenericDominatorEngine;
import org.vineflower.java.decompiler.modules.decompiler.decompose.IGraph;
import org.vineflower.java.decompiler.modules.decompiler.decompose.IGraphNode;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionNode;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.vineflower.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.vineflower.java.decompiler.util.collections.ListStack;
import org.vineflower.java.decompiler.util.collections.VBStyleCollection;

public class VarVersionsGraph {
    public final VBStyleCollection<VarVersionNode, VarVersionPair> nodes = new VBStyleCollection();
    private GenericDominatorEngine engine;

    public VarVersionNode createNode(VarVersionPair ver) {
        return this.createNode(ver, null);
    }

    public VarVersionNode createNode(VarVersionPair ver, StructLocalVariableTableAttribute.LocalVariable lvt) {
        VarVersionNode node = new VarVersionNode(ver.var, ver.version, lvt);
        this.nodes.addWithKey(node, ver);
        return node;
    }

    public boolean isDominatorSet(VarVersionNode node, Set<VarVersionNode> domnodes) {
        if (domnodes.size() == 1) {
            return this.engine.isDominator(node, domnodes.iterator().next());
        }
        if (domnodes.contains(node)) {
            return true;
        }
        HashSet<VarVersionNode> seen = new HashSet<VarVersionNode>();
        ArrayDeque<VarVersionNode> lstNodes = new ArrayDeque<VarVersionNode>();
        lstNodes.add(node);
        while (!lstNodes.isEmpty()) {
            VarVersionNode nd = (VarVersionNode)lstNodes.pollFirst();
            if (!seen.add(nd)) continue;
            if (nd.predecessors.isEmpty()) {
                return false;
            }
            for (VarVersionNode pred : nd.predecessors) {
                if (seen.contains(pred) || domnodes.contains(pred)) continue;
                lstNodes.addLast(pred);
            }
        }
        return true;
    }

    public void initDominators() {
        final HashSet<VarVersionNode> roots = new HashSet<VarVersionNode>();
        for (VarVersionNode node : this.nodes) {
            if (!node.predecessors.isEmpty()) continue;
            roots.add(node);
        }
        if (ValidationHelper.VALIDATE) {
            Set<VarVersionNode> reached = VarVersionsGraph.rootReachability(roots);
            ValidationHelper.validateTrue(this.nodes.size() == reached.size(), "Cyclic roots detected");
            if (this.nodes.size() != reached.size()) {
                HashSet intersection = new HashSet(this.nodes);
                intersection.removeAll(reached);
                HashMap<Integer, List> varMap = new HashMap<Integer, List>();
                HashSet<VarVersionNode> visited = new HashSet<VarVersionNode>();
                for (VarVersionNode node : intersection) {
                    if (visited.contains(node)) continue;
                    Set<VarVersionNode> found = this.findReachableNodes(node);
                    visited.addAll(found);
                    for (VarVersionNode foundNode : found) {
                        varMap.computeIfAbsent(foundNode.var, k -> new ArrayList()).add(foundNode.version);
                    }
                }
                for (Integer var : varMap.keySet()) {
                    ((List)varMap.get(var)).sort(Comparator.naturalOrder());
                    VarVersionPair pair = new VarVersionPair(var, (Integer)((List)varMap.get(var)).get(0));
                    roots.add(this.nodes.getWithKey(pair));
                }
            }
        }
        this.engine = new GenericDominatorEngine(new IGraph(){

            @Override
            public List<? extends IGraphNode> getReversePostOrderList() {
                return VarVersionsGraph.getReversedPostOrder(roots);
            }

            @Override
            public Set<? extends IGraphNode> getRoots() {
                return roots;
            }
        });
        this.engine.initialize();
    }

    private Set<VarVersionNode> findReachableNodes(VarVersionNode start) {
        HashSet<VarVersionNode> visited = new HashSet<VarVersionNode>();
        ListStack stack = new ListStack();
        stack.add(start);
        while (!stack.isEmpty()) {
            VarVersionNode node = (VarVersionNode)stack.pop();
            if (!visited.add(node)) continue;
            stack.addAll(node.successors);
        }
        return visited;
    }

    public static Set<VarVersionNode> rootReachability(Set<VarVersionNode> roots) {
        HashSet<VarVersionNode> visited = new HashSet<VarVersionNode>();
        ListStack<VarVersionNode> stack = new ListStack<VarVersionNode>((Collection<VarVersionNode>)roots);
        while (!stack.isEmpty()) {
            VarVersionNode node = stack.pop();
            if (!visited.add(node)) continue;
            stack.addAll(node.successors);
        }
        return visited;
    }

    public boolean areVarsAnalogous(int varBase, int varCheck) {
        ArrayDeque<VarVersionNode> stack = new ArrayDeque<VarVersionNode>();
        HashSet<VarVersionNode> visited = new HashSet<VarVersionNode>();
        VarVersionNode start = this.nodes.getWithKey(new VarVersionPair(varBase, 1));
        stack.add(start);
        while (!stack.isEmpty()) {
            VarVersionNode node = (VarVersionNode)stack.removeFirst();
            ValidationHelper.validateTrue(node.phantomParentNode == null && node.phantomNode == null, "`areVarsAnalogous` should not be called after ppmm or operator assignments resugaring");
            if (visited.contains(node)) continue;
            visited.add(node);
            VarVersionNode analog = this.nodes.getWithKey(new VarVersionPair(varCheck, node.version));
            if (analog == null) {
                return false;
            }
            if (node.successors.size() != analog.successors.size()) {
                return false;
            }
            for (VarVersionNode dest : node.successors) {
                stack.add(dest);
                VarVersionNode sucAnalog = this.nodes.getWithKey(new VarVersionPair(varCheck, dest.version));
                if (sucAnalog != null) continue;
                return false;
            }
        }
        return true;
    }

    private static List<VarVersionNode> getReversedPostOrder(Collection<VarVersionNode> roots) {
        ArrayList<VarVersionNode> lst = new ArrayList<VarVersionNode>();
        HashSet setVisited = new HashSet();
        ArrayDeque<VarVersionNode> stackNode = new ArrayDeque<VarVersionNode>();
        ArrayDeque<Integer> stackIndex = new ArrayDeque<Integer>();
        ArrayList<VarVersionNode> lstSuccs = new ArrayList<VarVersionNode>();
        for (VarVersionNode root : roots) {
            ArrayList lstTemp = new ArrayList();
            VarVersionsGraph.addToReversePostOrderListIterative(root, lstTemp, setVisited, stackNode, stackIndex, lstSuccs);
            lst.addAll(lstTemp);
        }
        return lst;
    }

    private static void addToReversePostOrderListIterative(VarVersionNode root, List<? super VarVersionNode> lst, Set<? super VarVersionNode> setVisited, Deque<VarVersionNode> stackNode, Deque<Integer> stackIndex, List<VarVersionNode> lstSuccs) {
        stackNode.clear();
        stackIndex.clear();
        stackNode.add(root);
        stackIndex.add(0);
        while (!stackNode.isEmpty()) {
            int index;
            VarVersionNode node = stackNode.peekLast();
            setVisited.add(node);
            lstSuccs.clear();
            lstSuccs.addAll(node.successors);
            for (index = stackIndex.removeLast().intValue(); index < lstSuccs.size(); ++index) {
                VarVersionNode succ = lstSuccs.get(index);
                if (setVisited.contains(succ)) continue;
                stackIndex.add(index + 1);
                stackNode.add(succ);
                stackIndex.add(0);
                break;
            }
            if (index != lstSuccs.size()) continue;
            lst.add(0, node);
            stackNode.removeLast();
        }
    }
}

