/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler.stats;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.util.TextBuffer;

public final class GeneralStatement
extends Statement {
    private boolean placeholder;

    public GeneralStatement(Statement head, Collection<? extends Statement> statements, Statement post) {
        super(Statement.StatementType.GENERAL);
        this.first = head;
        this.stats.addWithKey(head, head.id);
        LinkedHashSet<? extends Statement> set = new LinkedHashSet<Statement>(statements);
        set.remove(head);
        for (Statement statement : set) {
            this.stats.addWithKey(statement, statement.id);
        }
        this.post = post;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = new TextBuffer();
        if (this.isLabeled()) {
            buf.appendIndent(indent).append("label").append(this.id).append(":").appendLineSeparator();
        }
        buf.appendIndent(indent).append("abstract statement {").appendLineSeparator();
        for (Statement stat : this.stats) {
            buf.append(stat.toJava(indent + 1));
        }
        buf.appendIndent(indent).append("}");
        buf.appendLineSeparator();
        return buf;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }
}

