/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.vineflower.java.decompiler.modules.decompiler.ExprProcessor;
import org.vineflower.java.decompiler.modules.decompiler.StatEdge;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Pattern;
import org.vineflower.java.decompiler.modules.decompiler.exps.VarExprent;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.util.TextBuffer;

public class DoStatement
extends Statement {
    private Type looptype;
    private final List<Exprent> initExprent = new ArrayList<Exprent>();
    private final List<Exprent> conditionExprent = new ArrayList<Exprent>();
    private final List<Exprent> incExprent = new ArrayList<Exprent>();

    protected DoStatement() {
        super(Statement.StatementType.DO);
        this.looptype = Type.INFINITE;
        this.initExprent.add(null);
        this.conditionExprent.add(null);
        this.incExprent.add(null);
    }

    protected DoStatement(Statement head) {
        this();
        this.first = head;
        this.stats.addWithKey(this.first, this.first.id);
    }

    public static Statement isHead(Statement head) {
        if (head.getLastBasicType() == Statement.LastBasicType.GENERAL && !head.isMonitorEnter()) {
            StatEdge edge = null;
            List<StatEdge> lstSuccs = head.getSuccessorEdges(0x40000000);
            if (!lstSuccs.isEmpty()) {
                edge = lstSuccs.get(0);
            }
            if (edge != null && edge.getType() == 1 && edge.getDestination() == head) {
                return new DoStatement(head);
            }
            if (!(head instanceof DoStatement) && (edge == null || edge.getType() != 1) && head.getContinueSet().contains(head.getBasichead())) {
                return new DoStatement(head);
            }
        }
        return null;
    }

    @Override
    public HashSet<Statement> buildContinueSet() {
        super.buildContinueSet();
        this.continueSet.remove(this.first.getBasichead());
        return this.continueSet;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = new TextBuffer();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent));
        if (this.isLabeled()) {
            buf.appendIndent(indent).append("label").append(this.id).append(":").appendLineSeparator();
        }
        switch (this.looptype) {
            case INFINITE: {
                buf.appendIndent(indent).append("while (true) {").appendLineSeparator();
                buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, false));
                buf.appendIndent(indent).append("}").appendLineSeparator();
                break;
            }
            case DO_WHILE: {
                buf.appendIndent(indent).append("do {").appendLineSeparator();
                buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, false));
                buf.appendIndent(indent).append("} while (");
                buf.pushNewlineGroup(indent, 1);
                buf.appendPossibleNewline();
                buf.append(this.conditionExprent.get(0).toJava(indent));
                buf.appendPossibleNewline("", true);
                buf.popNewlineGroup();
                buf.append(");").appendLineSeparator();
                break;
            }
            case WHILE: {
                buf.appendIndent(indent).append("while (");
                buf.pushNewlineGroup(indent, 1);
                buf.appendPossibleNewline();
                buf.append(this.conditionExprent.get(0).toJava(indent));
                buf.appendPossibleNewline("", true);
                buf.popNewlineGroup();
                buf.append(") {").appendLineSeparator();
                buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, false));
                buf.appendIndent(indent).append("}").appendLineSeparator();
                break;
            }
            case FOR: {
                buf.appendIndent(indent);
                buf.pushNewlineGroup(indent, 1);
                buf.append("for (");
                if (this.initExprent.get(0) != null) {
                    buf.append(this.initExprent.get(0).toJava(indent));
                }
                buf.append(";").appendPossibleNewline(" ").append(this.conditionExprent.get(0).toJava(indent)).append(";").appendPossibleNewline(" ").append(this.incExprent.get(0).toJava(indent)).appendPossibleNewline("", true);
                buf.popNewlineGroup();
                buf.append(") {").appendLineSeparator();
                buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, false));
                buf.appendIndent(indent).append("}").appendLineSeparator();
                break;
            }
            case FOR_EACH: {
                buf.appendIndent(indent).append("for (").append(this.initExprent.get(0).toJava(indent));
                this.incExprent.get(0).getInferredExprType(null);
                buf.append(" : ").append(this.incExprent.get(0).toJava(indent)).append(") {").appendLineSeparator();
                buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, true));
                buf.appendIndent(indent).append("}").appendLineSeparator();
            }
        }
        return buf;
    }

    @Override
    public List<Object> getSequentialObjects() {
        ArrayList<Object> lst = new ArrayList<Object>();
        switch (this.looptype) {
            case FOR: {
                if (this.getInitExprent() != null) {
                    lst.add(this.getInitExprent());
                }
            }
            case WHILE: {
                lst.add(this.getConditionExprent());
                break;
            }
            case FOR_EACH: {
                lst.add(this.getInitExprent());
                lst.add(this.getIncExprent());
            }
        }
        lst.add(this.first);
        switch (this.looptype) {
            case DO_WHILE: {
                lst.add(this.getConditionExprent());
                break;
            }
            case FOR: {
                lst.add(this.getIncExprent());
            }
        }
        return lst;
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (this.initExprent.get(0) == oldexpr) {
            this.initExprent.set(0, newexpr);
        }
        if (this.conditionExprent.get(0) == oldexpr) {
            this.conditionExprent.set(0, newexpr);
        }
        if (this.incExprent.get(0) == oldexpr) {
            this.incExprent.set(0, newexpr);
        }
    }

    @Override
    public List<VarExprent> getImplicitlyDefinedVars() {
        ArrayList<VarExprent> vars = new ArrayList<VarExprent>();
        if (this.looptype == Type.FOR_EACH || this.getConditionExprent() == null) {
            return null;
        }
        List<Exprent> conditionList = this.getConditionExprent().getAllExprents(true, true);
        for (Exprent condition : conditionList) {
            FunctionExprent func;
            if (!(condition instanceof FunctionExprent) || (func = (FunctionExprent)condition).getFuncType() != FunctionExprent.FunctionType.INSTANCEOF || func.getLstOperands().size() <= 2) continue;
            vars.addAll(((Pattern)((Object)func.getLstOperands().get(2))).getPatternVars());
        }
        return vars;
    }

    @Override
    public boolean hasBasicSuccEdge() {
        return this.looptype != Type.INFINITE;
    }

    @Override
    public Statement getSimpleCopy() {
        return new DoStatement();
    }

    public List<Exprent> getInitExprentList() {
        return this.initExprent;
    }

    public List<Exprent> getConditionExprentList() {
        return this.conditionExprent;
    }

    public List<Exprent> getIncExprentList() {
        return this.incExprent;
    }

    public Exprent getConditionExprent() {
        return this.conditionExprent.get(0);
    }

    public void setConditionExprent(Exprent conditionExprent) {
        this.conditionExprent.set(0, conditionExprent);
    }

    public Exprent getIncExprent() {
        return this.incExprent.get(0);
    }

    public void setIncExprent(Exprent incExprent) {
        this.incExprent.set(0, incExprent);
    }

    public Exprent getInitExprent() {
        return this.initExprent.get(0);
    }

    public void setInitExprent(Exprent initExprent) {
        this.initExprent.set(0, initExprent);
    }

    public Type getLooptype() {
        return this.looptype;
    }

    public void setLooptype(Type looptype) {
        this.looptype = looptype;
    }

    public static enum Type {
        INFINITE,
        DO_WHILE,
        WHILE,
        FOR,
        FOR_EACH;

    }
}

