/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler.sforms;

import java.util.HashMap;
import java.util.Map;
import org.vineflower.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.VarExprent;
import org.vineflower.java.decompiler.modules.decompiler.sforms.SFormsConstructor;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.vineflower.java.decompiler.util.collections.FastSparseSetFactory;
import org.vineflower.java.decompiler.util.collections.SFormsFastMapDirect;

public class SSAConstructorSparseEx
extends SFormsConstructor {
    private final Map<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>> phi = new HashMap<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>>();

    public SSAConstructorSparseEx() {
        super(false, false);
    }

    @Override
    public void markDirectAssignment(VarVersionPair varVersionPair, VarVersionPair rightPair) {
    }

    @Override
    public VarVersionPair getOrCreatePhantom(VarVersionPair pair) {
        return pair;
    }

    @Override
    public Integer getFieldIndex(FieldExprent field) {
        return -1;
    }

    @Override
    void varReadSingleVersion(Statement stat, boolean calcLiveVars, VarExprent varExprent, SFormsFastMapDirect varmap, int lastVersion) {
        varExprent.setVersion(lastVersion);
    }

    @Override
    void varReadMultipleVersions(Statement stat, boolean calcLiveVars, VarExprent varExprent, SFormsFastMapDirect varMap, FastSparseSetFactory.FastSparseSet<Integer> versions) {
        int varIndex = varExprent.getIndex();
        int currentVersion = varExprent.getVersion();
        VarVersionPair varVersion = varExprent.getVarVersionPair();
        if (currentVersion != 0 && this.phi.containsKey(varVersion)) {
            this.phi.get(varVersion).union(versions);
        } else {
            int nextVer = this.getNextFreeVersion(varIndex, stat);
            varExprent.setVersion(nextVer);
            this.phi.put(varExprent.getVarVersionPair(), versions);
        }
        varMap.setCurrentVar(varExprent);
    }

    public Map<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>> getPhi() {
        return this.phi;
    }

    public Map<VarVersionPair, Integer> getSimpleReversePhiLookup() {
        HashMap<VarVersionPair, Integer> ret = new HashMap<VarVersionPair, Integer>();
        for (Map.Entry<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>> entry : this.phi.entrySet()) {
            int version;
            int index = entry.getKey().var;
            VarVersionPair left = entry.getKey();
            while (ret.containsKey(left) && (version = ((Integer)ret.get(left)).intValue()) != left.version) {
                left = new VarVersionPair(index, version);
            }
            for (int ver : entry.getValue()) {
                int version2;
                VarVersionPair right = new VarVersionPair(index, ver);
                while (ret.containsKey(right) && (version2 = ((Integer)ret.get(right)).intValue()) != right.version) {
                    right = new VarVersionPair(index, version2);
                }
                if (left.version == right.version) continue;
                if (right.version < left.version) {
                    ret.put(left, right.version);
                    left = right;
                    continue;
                }
                ret.put(right, left.version);
            }
        }
        for (Map.Entry<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>> entry : this.phi.entrySet()) {
            int version;
            VarVersionPair pair = entry.getKey();
            while (ret.containsKey(pair) && (version = ((Integer)ret.get(pair)).intValue()) != pair.version) {
                pair = new VarVersionPair(pair.var, version);
            }
            ret.put(entry.getKey(), pair.version);
        }
        return ret;
    }

    @Override
    void initVersion(VarExprent varExprent, Statement stat) {
        if (varExprent.getVersion() == 0) {
            int nextVersion = this.getNextFreeVersion(varExprent.getIndex(), stat);
            varExprent.setVersion(nextVersion);
        }
    }

    @Override
    public void initParameter(int varIndex, SFormsFastMapDirect varMap, boolean isCatchVar) {
        int version = this.getNextFreeVersion(varIndex, this.root);
        varMap.setCurrentVar(varIndex, version);
    }
}

