/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.vineflower.annotations.NotNull;
import org.vineflower.annotations.Nullable;
import org.vineflower.java.decompiler.modules.decompiler.DecHelper;
import org.vineflower.java.decompiler.modules.decompiler.ValidationHelper;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Pattern;
import org.vineflower.java.decompiler.modules.decompiler.exps.VarExprent;
import org.vineflower.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.vineflower.java.decompiler.struct.StructClass;
import org.vineflower.java.decompiler.struct.gen.VarType;
import org.vineflower.java.decompiler.util.TextBuffer;

public class PatternExprent
extends Exprent
implements Pattern {
    private final PatternData data;
    private final VarType varType;
    private final List<Exprent> exprents;
    private final List<@Nullable VarType> boundTypes;

    public PatternExprent(PatternData data, VarType type, List<Exprent> exprents) {
        super(Exprent.Type.PATTERN);
        this.data = data;
        this.varType = type;
        this.exprents = exprents;
        this.boundTypes = new ArrayList<VarType>();
        for (Exprent exprent : exprents) {
            if (!(exprent instanceof Pattern)) {
                ValidationHelper.assertTrue(false, "Illegal input for PatternExprent");
            }
            this.boundTypes.add(null);
        }
    }

    @Override
    protected List<Exprent> getAllExprents(List<Exprent> list) {
        list.addAll(this.exprents);
        return list;
    }

    @Override
    public VarType getExprType() {
        return this.varType;
    }

    @Override
    public Exprent copy() {
        return new PatternExprent(this.data, this.varType, DecHelper.copyExprentList(this.exprents));
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = new TextBuffer();
        buf.appendCastTypeName(this.varType);
        buf.append("(");
        for (int i = 0; i < this.exprents.size(); ++i) {
            buf.append(this.exprents.get(i).toJava());
            if (i >= this.exprents.size() - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        PatternData patternData = this.data;
        if (patternData instanceof PatternData.RecordPatternData) {
            PatternData.RecordPatternData record = (PatternData.RecordPatternData)patternData;
            CheckTypesResult res = new CheckTypesResult();
            ValidationHelper.assertTrue(record.cl.getRecordComponents() != null, "Must not be null!");
            ValidationHelper.assertTrue(record.cl.getRecordComponents().size() == this.exprents.size(), "Record component size and expr list size must be equal!");
            for (int i = 0; i < this.exprents.size(); ++i) {
                VarType type = this.boundTypes.get(i);
                if (type != null) {
                    res.addMinTypeExprent(this.exprents.get(i), type);
                    continue;
                }
                res.addMinTypeExprent(this.exprents.get(i), new VarType(record.cl.getRecordComponents().get(i).getDescriptor()));
            }
            return res;
        }
        return super.checkExprTypeBounds();
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        PatternExprent.measureBytecode(values, this.exprents);
        this.measureBytecode(values);
    }

    @Override
    @NotNull
    public List<VarExprent> getPatternVars() {
        ArrayList<VarExprent> vars = new ArrayList<VarExprent>();
        for (Exprent e : this.exprents) {
            if (e instanceof Pattern) {
                Pattern p = (Pattern)((Object)e);
                vars.addAll(p.getPatternVars());
                continue;
            }
            ValidationHelper.assertTrue(false, "Illegal input in PatternExprent");
        }
        return vars;
    }

    public PatternData getData() {
        return this.data;
    }

    public List<Exprent> getExprents() {
        return this.exprents;
    }

    public List<@Nullable VarType> getBoundTypes() {
        return this.boundTypes;
    }

    public static PatternData recordData(StructClass cl) {
        return new PatternData.RecordPatternData(cl);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PatternData {

        public record RecordPatternData(StructClass cl) implements PatternData
        {
        }
    }
}

