/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.plugins.PluginImplementationException;
import org.vineflower.java.decompiler.modules.decompiler.ExprProcessor;
import org.vineflower.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Pattern;
import org.vineflower.java.decompiler.modules.decompiler.exps.VarExprent;
import org.vineflower.java.decompiler.modules.decompiler.sforms.SFormsConstructor;
import org.vineflower.java.decompiler.modules.decompiler.sforms.VarMapHolder;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.vineflower.java.decompiler.struct.gen.CodeType;
import org.vineflower.java.decompiler.struct.gen.VarType;
import org.vineflower.java.decompiler.struct.gen.generics.GenericType;
import org.vineflower.java.decompiler.struct.match.IMatchable;
import org.vineflower.java.decompiler.struct.match.MatchEngine;
import org.vineflower.java.decompiler.struct.match.MatchNode;
import org.vineflower.java.decompiler.util.IntHelper;
import org.vineflower.java.decompiler.util.InterpreterUtil;
import org.vineflower.java.decompiler.util.TextBuffer;
import org.vineflower.java.decompiler.util.Typed;
import org.vineflower.java.decompiler.util.collections.ListStack;
import org.vineflower.java.decompiler.util.collections.SFormsFastMapDirect;

public class FunctionExprent
extends Exprent {
    private static final CodeType[] TYPE_PRIMITIVES = new CodeType[]{CodeType.DOUBLE, CodeType.FLOAT, CodeType.LONG};
    private static final VarType[] TYPES = new VarType[]{VarType.VARTYPE_DOUBLE, VarType.VARTYPE_FLOAT, VarType.VARTYPE_LONG};
    private static final Set<FunctionType> ASSOCIATIVITY = new HashSet<FunctionType>(Arrays.asList(FunctionType.ADD, FunctionType.MUL, FunctionType.AND, FunctionType.OR, FunctionType.XOR, FunctionType.BOOLEAN_AND, FunctionType.BOOLEAN_OR, FunctionType.STR_CONCAT));
    private FunctionType funcType;
    private VarType implicitType;
    private final List<Exprent> lstOperands;
    private boolean needsCast = true;
    private boolean disableNewlineGroupCreation = false;

    public FunctionExprent(FunctionType funcType, ListStack<Exprent> stack, BitSet bytecodeOffsets) {
        this(funcType, new ArrayList<Exprent>(), bytecodeOffsets);
        if (funcType.arity == 1) {
            this.lstOperands.add(stack.pop());
        } else if (funcType.arity == 2) {
            Exprent expr = stack.pop();
            this.lstOperands.add(stack.pop());
            this.lstOperands.add(expr);
        } else {
            throw new RuntimeException("no direct instantiation possible: " + String.valueOf(funcType));
        }
    }

    public FunctionExprent(FunctionType funcType, List<Exprent> operands, BitSet bytecodeOffsets) {
        super(Exprent.Type.FUNCTION);
        this.funcType = funcType;
        this.lstOperands = operands;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    public FunctionExprent(FunctionType funcType, Exprent operand, BitSet bytecodeOffsets) {
        this(funcType, new ArrayList<Exprent>(1), bytecodeOffsets);
        this.lstOperands.add(operand);
    }

    @Override
    public VarType getExprType() {
        VarType staticType = this.funcType.type;
        if (staticType != null) {
            return staticType;
        }
        switch (this.funcType) {
            case IMM: 
            case MMI: 
            case IPP: 
            case PPI: {
                return this.implicitType;
            }
            case SHL: 
            case SHR: 
            case USHR: 
            case BIT_NOT: 
            case NEG: {
                return FunctionExprent.getMaxVarType(this.lstOperands.get(0).getExprType());
            }
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case REM: {
                return FunctionExprent.getMaxVarType(this.lstOperands.get(0).getExprType(), this.lstOperands.get(1).getExprType());
            }
            case AND: 
            case OR: 
            case XOR: {
                VarType type1 = this.lstOperands.get(0).getExprType();
                VarType type2 = this.lstOperands.get(1).getExprType();
                if (type1.type == CodeType.BOOLEAN && type2.type == CodeType.BOOLEAN) {
                    return VarType.VARTYPE_BOOLEAN;
                }
                return FunctionExprent.getMaxVarType(type1, type2);
            }
            case CAST: {
                return this.lstOperands.get(1).getExprType();
            }
            case TERNARY: {
                Exprent param1 = this.lstOperands.get(1);
                Exprent param2 = this.lstOperands.get(2);
                VarType supertype = VarType.getCommonSupertype(param1.getExprType(), param2.getExprType());
                if (supertype == null) {
                    throw new IllegalStateException("No common supertype for ternary expression");
                }
                if (param1 instanceof ConstExprent && param2 instanceof ConstExprent && supertype.type != CodeType.BOOLEAN && VarType.VARTYPE_INT.isSuperset(supertype)) {
                    return VarType.VARTYPE_INT;
                }
                return supertype;
            }
            case OTHER: {
                throw new PluginImplementationException();
            }
        }
        throw new IllegalStateException("No type for funcType=" + String.valueOf(this.funcType));
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        if (this.funcType == FunctionType.CAST) {
            this.needsCast = true;
            VarType right = this.lstOperands.get(0).getInferredExprType(upperBound);
            List<VarType> cast = this.lstOperands.subList(1, this.lstOperands.size()).stream().map(Exprent::getExprType).toList();
            if (upperBound != null && (upperBound.isGeneric() || right.isGeneric())) {
                List<VarType> types;
                Map<VarType, List<VarType>> names = this.getNamedGenerics();
                int arrayDim = 0;
                if (upperBound.arrayDim == right.arrayDim && upperBound.arrayDim > 0) {
                    arrayDim = upperBound.arrayDim;
                    upperBound = upperBound.resizeArrayDim(0);
                    right = right.resizeArrayDim(0);
                }
                if ((types = names.get(right)) == null) {
                    types = names.get(upperBound);
                }
                if (types != null) {
                    List<VarType> finalTypes = types;
                    if (cast.stream().allMatch(castType -> finalTypes.stream().anyMatch(type -> DecompilerContext.getStructContext().instanceOf(type.value, castType.value)))) {
                        this.needsCast = false;
                    }
                } else {
                    boolean bl = this.needsCast = right.type == CodeType.NULL || !DecompilerContext.getStructContext().instanceOf(right.value, upperBound.value) || !FunctionExprent.areGenericTypesSame(right, upperBound);
                }
                if (!this.needsCast) {
                    if (arrayDim > 0) {
                        right = right.resizeArrayDim(arrayDim);
                    }
                    return right;
                }
            } else {
                VarType finalRight = right;
                this.needsCast = right.type == CodeType.NULL || cast.stream().anyMatch(castType -> !DecompilerContext.getStructContext().instanceOf(finalRight.value, castType.value)) || cast.stream().anyMatch(castType -> finalRight.arrayDim != castType.arrayDim);
            }
            return this.getExprType();
        }
        if (this.funcType == FunctionType.TERNARY) {
            VarType type1 = this.lstOperands.get(1).getInferredExprType(upperBound);
            VarType type2 = this.lstOperands.get(2).getInferredExprType(upperBound);
            if (type1.type == CodeType.NULL) {
                return type2;
            }
            if (type2.type == CodeType.NULL) {
                return type1;
            }
            VarType union = VarType.getCommonSupertype(type1, type2);
            if (union != null && this.lstOperands.get(1) instanceof ConstExprent && this.lstOperands.get(2) instanceof ConstExprent && union.type != CodeType.BOOLEAN && VarType.VARTYPE_INT.isSuperset(union)) {
                union = VarType.VARTYPE_INT;
            }
            return union != null ? union : this.getExprType();
        }
        if (this.funcType == FunctionType.INSTANCEOF) {
            for (Exprent oper : this.lstOperands) {
                oper.getInferredExprType(null);
            }
            return this.getExprType();
        }
        for (Exprent oper : this.lstOperands) {
            oper.getInferredExprType(upperBound);
        }
        return this.getExprType();
    }

    private static boolean areGenericTypesSame(VarType right, VarType upperBound) {
        if (!(right instanceof GenericType) || !(upperBound instanceof GenericType)) {
            return true;
        }
        GenericType rightGeneric = (GenericType)right;
        GenericType upperBoundGeneric = (GenericType)upperBound;
        if (rightGeneric.getArguments().size() != upperBoundGeneric.getArguments().size()) {
            return false;
        }
        for (int i = 0; i < upperBoundGeneric.getArguments().size(); ++i) {
            VarType upperType = upperBoundGeneric.getArguments().get(i);
            VarType rightType = rightGeneric.getArguments().get(i);
            if (upperType == null || rightType != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getExprentUse() {
        if (this.funcType.ordinal() >= FunctionType.IMM.ordinal() && this.funcType.ordinal() <= FunctionType.PPI.ordinal()) {
            return 0;
        }
        int ret = 3;
        for (Exprent expr : this.lstOperands) {
            ret &= expr.getExprentUse();
        }
        return ret;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        Exprent param1 = this.lstOperands.get(0);
        VarType type1 = param1.getExprType();
        Exprent param2 = null;
        VarType type2 = null;
        if (this.lstOperands.size() > 1) {
            param2 = this.lstOperands.get(1);
            type2 = param2.getExprType();
        }
        switch (this.funcType) {
            case TERNARY: {
                VarType supertype = this.getExprType();
                result.addMinTypeExprent(param1, VarType.VARTYPE_BOOLEAN);
                result.addMinTypeExprent(param2, VarType.getMinTypeInFamily(supertype.typeFamily));
                result.addMinTypeExprent(this.lstOperands.get(2), VarType.getMinTypeInFamily(supertype.typeFamily));
                break;
            }
            case I2L: 
            case I2F: 
            case I2D: 
            case I2B: 
            case I2C: 
            case I2S: {
                result.addMinTypeExprent(param1, VarType.VARTYPE_BYTECHAR);
                result.addMaxTypeExprent(param1, VarType.VARTYPE_INT);
                break;
            }
            case IMM: 
            case MMI: 
            case IPP: 
            case PPI: {
                result.addMinTypeExprent(param1, this.implicitType);
                result.addMaxTypeExprent(param1, this.implicitType);
                break;
            }
            case SHL: 
            case SHR: 
            case USHR: 
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case REM: 
            case LT: 
            case GE: 
            case GT: 
            case LE: {
                result.addMinTypeExprent(param2, VarType.VARTYPE_BYTECHAR);
            }
            case BIT_NOT: 
            case NEG: {
                result.addMinTypeExprent(param1, VarType.VARTYPE_BYTECHAR);
                break;
            }
            case AND: 
            case OR: 
            case XOR: 
            case EQ: 
            case NE: {
                if (type1.type == CodeType.BOOLEAN) {
                    boolean param2_false_boolean;
                    if (type2.isStrictSuperset(type1)) {
                        result.addMinTypeExprent(param1, VarType.VARTYPE_BYTECHAR);
                        break;
                    }
                    boolean param1_false_boolean = param1 instanceof ConstExprent && !((ConstExprent)param1).hasBooleanValue();
                    boolean bl = param2_false_boolean = param2 instanceof ConstExprent && !((ConstExprent)param2).hasBooleanValue();
                    if (!param1_false_boolean && !param2_false_boolean) break;
                    result.addMinTypeExprent(param1, VarType.VARTYPE_BYTECHAR);
                    result.addMinTypeExprent(param2, VarType.VARTYPE_BYTECHAR);
                    break;
                }
                if (type2.type != CodeType.BOOLEAN || !type1.isStrictSuperset(type2)) break;
                result.addMinTypeExprent(param2, VarType.VARTYPE_BYTECHAR);
                break;
            }
            case INSTANCEOF: {
                Exprent exprent;
                if (this.lstOperands.size() <= 2 || !((exprent = this.lstOperands.get(2)) instanceof VarExprent)) break;
                VarExprent var = (VarExprent)exprent;
                result.addMinTypeExprent(var, this.lstOperands.get(1).getExprType());
                break;
            }
            case STR_CONCAT: {
                VarType type;
                VarType varType = type = this.implicitType == null ? VarType.VARTYPE_STRING : this.implicitType;
                if (type1.typeFamily == type.typeFamily) {
                    result.addMinTypeExprent(param1, type);
                }
                if (type2.typeFamily != type.typeFamily) break;
                result.addMinTypeExprent(param2, type);
                break;
            }
            case OTHER: {
                throw new PluginImplementationException();
            }
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        lst.addAll(this.lstOperands);
        return lst;
    }

    @Override
    public Exprent copy() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        for (Exprent expr : this.lstOperands) {
            lst.add(expr.copy());
        }
        FunctionExprent func = new FunctionExprent(this.funcType, lst, this.bytecode);
        func.setImplicitType(this.implicitType);
        return func;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionExprent)) {
            return false;
        }
        FunctionExprent fe = (FunctionExprent)o;
        return this.funcType == fe.getFuncType() && InterpreterUtil.equalLists(this.lstOperands, fe.getLstOperands());
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        for (int i = 0; i < this.lstOperands.size(); ++i) {
            if (oldExpr != this.lstOperands.get(i)) continue;
            this.lstOperands.set(i, newExpr);
        }
    }

    @Override
    public TextBuffer toJava(int indent) {
        if (this.funcType == FunctionType.OTHER) {
            throw new PluginImplementationException();
        }
        TextBuffer buf = new TextBuffer();
        buf.addBytecodeMapping(this.bytecode);
        if (this.funcType.isArithmeticBinaryOperation()) {
            Exprent left = this.lstOperands.get(0);
            Exprent right = this.lstOperands.get(1);
            if (this.funcType.isArithmeticBinaryOperation()) {
                if (right instanceof ConstExprent) {
                    ((ConstExprent)right).adjustConstType(left.getExprType());
                } else if (left instanceof ConstExprent) {
                    ((ConstExprent)left).adjustConstType(right.getExprType());
                }
            }
            TextBuffer leftOperand = this.wrapOperandString(left, false, indent, true);
            TextBuffer rightOperand = this.wrapOperandString(right, true, indent, true);
            if (this.funcType == FunctionType.AND || this.funcType == FunctionType.OR) {
                Integer value;
                if (right instanceof ConstExprent && right.getExprType() == VarType.VARTYPE_INT) {
                    value = (Integer)((ConstExprent)right).getValue();
                    rightOperand.setLength(0);
                    rightOperand.append(IntHelper.adjustedIntRepresentation(value));
                }
                if (left instanceof ConstExprent && left.getExprType() == VarType.VARTYPE_INT) {
                    value = (Integer)((ConstExprent)left).getValue();
                    leftOperand.setLength(0);
                    leftOperand.append(IntHelper.adjustedIntRepresentation(value));
                }
            }
            if (!this.disableNewlineGroupCreation) {
                buf.pushNewlineGroup(indent, 1);
            }
            buf.append(leftOperand).appendPossibleNewline(" ").append(this.funcType.operator).append(" ").append(rightOperand);
            if (!this.disableNewlineGroupCreation) {
                buf.popNewlineGroup();
            }
            return buf;
        }
        if (this.funcType.ordinal() >= FunctionType.EQ.ordinal()) {
            Exprent left = this.lstOperands.get(0);
            Exprent right = this.lstOperands.get(1);
            if (this.funcType.ordinal() <= FunctionType.LE.ordinal()) {
                VarType other;
                if (right instanceof ConstExprent) {
                    VarType other2 = left.getExprType();
                    if (other2 != null) {
                        ((ConstExprent)right).adjustConstType(other2);
                    }
                } else if (left instanceof ConstExprent && (other = right.getExprType()) != null) {
                    ((ConstExprent)left).adjustConstType(other);
                }
            }
            if (!this.disableNewlineGroupCreation) {
                buf.pushNewlineGroup(indent, 1);
            }
            buf.append(this.wrapOperandString(left, false, indent, true)).appendPossibleNewline(" ").append(this.funcType.operator).append(" ").append(this.wrapOperandString(right, true, indent, true));
            if (!this.disableNewlineGroupCreation) {
                buf.popNewlineGroup();
            }
            return buf;
        }
        switch (this.funcType) {
            case MMI: 
            case PPI: 
            case BIT_NOT: 
            case NEG: 
            case BOOL_NOT: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend(this.funcType.operator));
            }
            case IMM: 
            case IPP: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).append(this.funcType.operator));
            }
            case CAST: {
                if (!this.needsCast) {
                    return buf.append(this.lstOperands.get(0).toJava(indent));
                }
                for (int i = 1; i < this.lstOperands.size(); ++i) {
                    if (i > 1) {
                        buf.append(" & ");
                    }
                    buf.append(this.lstOperands.get(i).toJava(indent));
                }
                return buf.encloseWithParens().append(this.wrapOperandString(this.lstOperands.get(0), true, indent));
            }
            case ARRAY_LENGTH: {
                Exprent arr = this.lstOperands.get(0);
                buf.append(this.wrapOperandString(arr, false, indent));
                if (arr.getExprType().arrayDim == 0) {
                    VarType objArr = VarType.VARTYPE_OBJECT.resizeArrayDim(1);
                    buf.enclose("((" + ExprProcessor.getCastTypeName(objArr) + ")", ")");
                    buf.addTypeNameToken(objArr, 2);
                }
                return buf.append(".length");
            }
            case TERNARY: {
                buf.pushNewlineGroup(indent, 1);
                buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent)).appendPossibleNewline(" ").append("? ").append(this.wrapOperandString(this.lstOperands.get(1), true, indent)).appendPossibleNewline(" ").append(": ").append(this.wrapOperandString(this.lstOperands.get(2), true, indent));
                buf.popNewlineGroup();
                return buf;
            }
            case INSTANCEOF: {
                buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent)).append(" instanceof ");
                if (this.lstOperands.size() > 2) {
                    Pattern pattern = (Pattern)((Object)this.lstOperands.get(2));
                    for (VarExprent var : pattern.getPatternVars()) {
                        var.setWritingPattern();
                    }
                    buf.append(this.wrapOperandString(this.lstOperands.get(2), true, indent));
                } else {
                    buf.append(this.wrapOperandString(this.lstOperands.get(1), true, indent));
                }
                return buf;
            }
            case LCMP: 
            case FCMPL: 
            case FCMPG: 
            case DCMPL: 
            case DCMPG: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend(this.funcType.operator + "(")).append(", ").append(this.wrapOperandString(this.lstOperands.get(1), true, indent)).append(")");
            }
        }
        if (this.funcType.castType != null) {
            InvocationExprent inv;
            if (this.lstOperands.get(0) instanceof InvocationExprent && (inv = (InvocationExprent)this.lstOperands.get(0)).isUnboxingCall()) {
                inv.forceUnboxing(true);
            }
            if (!this.needsCast) {
                return buf.append(this.lstOperands.get(0).toJava(indent));
            }
            return buf.append(ExprProcessor.getTypeName(this.funcType.castType)).encloseWithParens().append(this.wrapOperandString(this.lstOperands.get(0), true, indent));
        }
        throw new RuntimeException("invalid function");
    }

    private Exprent unwrapBoxing(Exprent expr) {
        Exprent inner;
        if (expr instanceof InvocationExprent && ((InvocationExprent)expr).isUnboxingCall() && (inner = ((InvocationExprent)expr).getInstance()) instanceof FunctionExprent && ((FunctionExprent)inner).funcType == FunctionType.CAST) {
            inner.addBytecodeOffsets(expr.bytecode);
            expr = inner;
        }
        return expr;
    }

    public void unwrapBox() {
        for (int i = 0; i < this.lstOperands.size(); ++i) {
            this.lstOperands.set(i, this.unwrapBoxing(this.lstOperands.get(i)));
        }
    }

    @Override
    public int getPrecedence() {
        if (!(this.funcType != FunctionType.CAST && this.funcType.castType == null || this.doesCast())) {
            return this.lstOperands.get(0).getPrecedence();
        }
        if (this.funcType == FunctionType.OTHER) {
            throw new PluginImplementationException();
        }
        return this.funcType.precedence;
    }

    public VarType getSimpleCastType() {
        return this.funcType.castType;
    }

    protected TextBuffer wrapOperandString(Exprent expr, boolean eq, int indent) {
        return this.wrapOperandString(expr, eq, indent, false);
    }

    private TextBuffer wrapOperandString(Exprent expr, boolean eq, int indent, boolean newlineGroup) {
        boolean parentheses;
        int myprec = this.getPrecedence();
        int exprprec = expr.getPrecedence();
        boolean bl = parentheses = exprprec > myprec;
        if (!parentheses && eq) {
            boolean bl2 = parentheses = exprprec == myprec;
            if (parentheses && expr instanceof FunctionExprent && ((FunctionExprent)expr).getFuncType() == this.funcType && expr.getExprType() != VarType.VARTYPE_FLOAT && expr.getExprType() != VarType.VARTYPE_DOUBLE) {
                boolean bl3 = parentheses = !ASSOCIATIVITY.contains(this.funcType);
            }
        }
        if (newlineGroup && !parentheses && myprec == exprprec && expr instanceof FunctionExprent) {
            Exprent subExpr;
            FunctionExprent funcExpr = (FunctionExprent)expr;
            if (funcExpr.getFuncType() == FunctionType.CAST && !funcExpr.doesCast() && (subExpr = funcExpr.getLstOperands().get(0)) instanceof FunctionExprent) {
                funcExpr = (FunctionExprent)subExpr;
            }
            funcExpr.disableNewlineGroupCreation = true;
        }
        TextBuffer res = expr.toJava(indent);
        if (parentheses) {
            TextBuffer oldRes = res;
            res = new TextBuffer().append("(");
            res.pushNewlineGroup(indent, 1);
            res.appendPossibleNewline();
            res.append(oldRes);
            res.appendPossibleNewline("", true);
            res.popNewlineGroup();
            res.append(")");
        }
        return res;
    }

    private static VarType getMaxVarType(VarType ... arr) {
        for (int i = 0; i < TYPE_PRIMITIVES.length; ++i) {
            for (VarType anArr : arr) {
                if (anArr.type != TYPE_PRIMITIVES[i]) continue;
                return TYPES[i];
            }
        }
        return VarType.VARTYPE_INT;
    }

    public FunctionType getFuncType() {
        return this.funcType;
    }

    public void setFuncType(FunctionType funcType) {
        this.funcType = funcType;
    }

    public List<Exprent> getLstOperands() {
        return this.lstOperands;
    }

    public void setImplicitType(VarType implicitType) {
        this.implicitType = implicitType;
    }

    public boolean doesCast() {
        return this.needsCast;
    }

    public void setNeedsCast(boolean needsCast) {
        this.needsCast = needsCast;
    }

    @Override
    public void setInvocationInstance() {
        if (this.funcType == FunctionType.CAST) {
            this.lstOperands.get(0).setInvocationInstance();
        }
    }

    @Override
    public void setIsQualifier() {
        if (this.funcType == FunctionType.CAST && !this.doesCast()) {
            this.lstOperands.get(0).setIsQualifier();
        }
    }

    @Override
    public boolean allowNewlineAfterQualifier() {
        if (this.funcType == FunctionType.CAST && !this.doesCast()) {
            return this.lstOperands.get(0).allowNewlineAfterQualifier();
        }
        return super.allowNewlineAfterQualifier();
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        FunctionExprent.measureBytecode(values, this.lstOperands);
        this.measureBytecode(values);
    }

    @Override
    public void processSforms(SFormsConstructor sFormsConstructor, VarMapHolder varMaps, Statement stat, boolean calcLiveVars) {
        switch (this.getFuncType()) {
            case TERNARY: {
                this.getLstOperands().get(0).processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                VarMapHolder bVarMaps = VarMapHolder.ofNormal(varMaps.getIfTrue());
                this.getLstOperands().get(1).processSforms(sFormsConstructor, bVarMaps, stat, calcLiveVars);
                varMaps.setNormal(varMaps.getIfFalse());
                this.getLstOperands().get(2).processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                if (bVarMaps.isNormal() && varMaps.isNormal()) {
                    varMaps.mergeNormal(bVarMaps.getNormal());
                } else if (!varMaps.isNormal()) {
                    varMaps.mergeIfTrue(bVarMaps.getIfTrue());
                    varMaps.mergeIfFalse(bVarMaps.getIfFalse());
                } else {
                    bVarMaps.mergeIfTrue(varMaps.getNormal());
                    bVarMaps.mergeIfFalse(varMaps.getNormal());
                    varMaps.set(bVarMaps);
                }
                return;
            }
            case BOOLEAN_AND: {
                this.getLstOperands().get(0).processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                varMaps.makeFullyMutable();
                SFormsFastMapDirect ifFalse = varMaps.getIfFalse();
                varMaps.setNormal(varMaps.getIfTrue());
                this.getLstOperands().get(1).processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                varMaps.mergeIfFalse(ifFalse);
                return;
            }
            case BOOLEAN_OR: {
                this.getLstOperands().get(0).processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                varMaps.makeFullyMutable();
                SFormsFastMapDirect ifTrue = varMaps.getIfTrue();
                varMaps.setNormal(varMaps.getIfFalse());
                this.getLstOperands().get(1).processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                varMaps.mergeIfTrue(ifTrue);
                return;
            }
            case BOOL_NOT: {
                this.getLstOperands().get(0).processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                varMaps.swap();
                return;
            }
            case INSTANCEOF: {
                this.getLstOperands().get(0).processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                varMaps.toNormal();
                if (this.getLstOperands().size() == 3) {
                    varMaps.makeFullyMutable();
                    Pattern pattern = (Pattern)((Object)this.getLstOperands().get(2));
                    for (VarExprent var : pattern.getPatternVars()) {
                        sFormsConstructor.updateVarExprent(var, stat, varMaps.getIfTrue(), calcLiveVars);
                    }
                }
                return;
            }
            case IMM: 
            case MMI: 
            case IPP: 
            case PPI: {
                this.getLstOperands().get(0).processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                switch (this.getLstOperands().get((int)0).type) {
                    case VAR: {
                        VarExprent varExprent = (VarExprent)this.getLstOperands().get(0);
                        VarVersionPair phantomPair = sFormsConstructor.getOrCreatePhantom(varExprent.getVarVersionPair());
                        varMaps.getNormal().setCurrentVar(phantomPair);
                        break;
                    }
                    case FIELD: {
                        varMaps.getNormal().removeAllFields();
                    }
                }
                return;
            }
        }
        super.processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        FunctionType type = (FunctionType)matchNode.getRuleValue(IMatchable.MatchProperties.EXPRENT_FUNCTYPE);
        return type == null || this.funcType == type;
    }

    public static enum FunctionType implements Typed
    {
        ADD(2, "+", 3, null),
        SUB(2, "-", 3, null),
        MUL(2, "*", 2, null),
        DIV(2, "/", 2, null),
        AND(2, "&", 7, null),
        OR(2, "|", 9, null),
        XOR(2, "^", 8, null),
        REM(2, "%", 2, null),
        SHL(2, "<<", 4, null),
        SHR(2, ">>", 4, null),
        USHR(2, ">>>", 4, null),
        BIT_NOT(1, "~", 1, null),
        BOOL_NOT(1, "!", 1, VarType.VARTYPE_BOOLEAN),
        NEG(1, "-", 1, null),
        I2L(VarType.VARTYPE_LONG),
        I2F(VarType.VARTYPE_FLOAT),
        I2D(VarType.VARTYPE_DOUBLE),
        L2I(VarType.VARTYPE_INT),
        L2F(VarType.VARTYPE_FLOAT),
        L2D(VarType.VARTYPE_DOUBLE),
        F2I(VarType.VARTYPE_INT),
        F2L(VarType.VARTYPE_LONG),
        F2D(VarType.VARTYPE_DOUBLE),
        D2I(VarType.VARTYPE_INT),
        D2L(VarType.VARTYPE_LONG),
        D2F(VarType.VARTYPE_FLOAT),
        I2B(VarType.VARTYPE_BYTE),
        I2C(VarType.VARTYPE_CHAR),
        I2S(VarType.VARTYPE_SHORT),
        CAST(2, null, 1, null),
        INSTANCEOF(2, "instanceof", 6, VarType.VARTYPE_BOOLEAN),
        ARRAY_LENGTH(1, null, 0, VarType.VARTYPE_INT),
        IMM(1, "--", 1, null),
        MMI(1, "--", 1, null),
        IPP(1, "++", 1, null),
        PPI(1, "++", 1, null),
        TERNARY(3, null, 12, null),
        LCMP(2, "__lcmp__", -1, VarType.VARTYPE_BOOLEAN),
        FCMPL(2, "__fcmpl__", -1, VarType.VARTYPE_BOOLEAN),
        FCMPG(2, "__fcmpg__", -1, VarType.VARTYPE_BOOLEAN),
        DCMPL(2, "__dcmpl__", -1, VarType.VARTYPE_BOOLEAN),
        DCMPG(2, "__dcmpg__", -1, VarType.VARTYPE_BOOLEAN),
        EQ(2, "==", 6, VarType.VARTYPE_BOOLEAN),
        NE(2, "!=", 6, VarType.VARTYPE_BOOLEAN),
        LT(2, "<", 5, VarType.VARTYPE_BOOLEAN),
        GE(2, ">=", 5, VarType.VARTYPE_BOOLEAN),
        GT(2, ">", 5, VarType.VARTYPE_BOOLEAN),
        LE(2, "<=", 5, VarType.VARTYPE_BOOLEAN),
        BOOLEAN_AND(2, "&&", 10, VarType.VARTYPE_BOOLEAN),
        BOOLEAN_OR(2, "||", 11, VarType.VARTYPE_BOOLEAN),
        STR_CONCAT(2, "+", 3, VarType.VARTYPE_STRING),
        OTHER(0, "??????", 999, null);

        public final int arity;
        public final String operator;
        public final int precedence;
        public final VarType castType;
        final VarType type;

        private FunctionType(int arity, String operator, int precedence, VarType type) {
            this(arity, operator, precedence, null, type);
        }

        private FunctionType(VarType castType) {
            this(1, null, 1, castType, castType);
        }

        private FunctionType(int arity, String operator, int precedence, VarType castType, VarType type) {
            this.arity = arity;
            this.operator = operator;
            this.precedence = precedence;
            this.castType = castType;
            this.type = type;
        }

        public boolean isArithmeticBinaryOperation() {
            return this.ordinal() <= USHR.ordinal();
        }

        public boolean isMM() {
            return this == MMI || this == IMM;
        }

        public boolean isPP() {
            return this == PPI || this == IPP;
        }

        public boolean isPPMM() {
            return this.isPP() || this.isMM();
        }

        public boolean isPostfixPPMM() {
            return this == IMM || this == IPP;
        }
    }
}

