/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vineflower.java.decompiler.main.ClassesProcessor;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.rels.MethodWrapper;
import org.vineflower.java.decompiler.modules.decompiler.ExprProcessor;
import org.vineflower.java.decompiler.modules.decompiler.exps.ExprUtil;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.VarExprent;
import org.vineflower.java.decompiler.modules.decompiler.sforms.SFormsConstructor;
import org.vineflower.java.decompiler.modules.decompiler.sforms.VarMapHolder;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.vineflower.java.decompiler.struct.StructClass;
import org.vineflower.java.decompiler.struct.StructField;
import org.vineflower.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.vineflower.java.decompiler.struct.consts.LinkConstant;
import org.vineflower.java.decompiler.struct.gen.CodeType;
import org.vineflower.java.decompiler.struct.gen.FieldDescriptor;
import org.vineflower.java.decompiler.struct.gen.VarType;
import org.vineflower.java.decompiler.struct.gen.generics.GenericType;
import org.vineflower.java.decompiler.struct.match.IMatchable;
import org.vineflower.java.decompiler.struct.match.MatchEngine;
import org.vineflower.java.decompiler.struct.match.MatchNode;
import org.vineflower.java.decompiler.util.InterpreterUtil;
import org.vineflower.java.decompiler.util.TextBuffer;
import org.vineflower.java.decompiler.util.TextUtil;

public class FieldExprent
extends Exprent {
    private final String name;
    private final String classname;
    private final boolean isStatic;
    private Exprent instance;
    private final FieldDescriptor descriptor;
    private boolean forceQualified = false;
    private boolean isQualifier = false;
    private boolean wasCondy = false;

    public FieldExprent(LinkConstant cn, Exprent instance, BitSet bytecodeOffsets) {
        this(cn.elementname, cn.classname, instance == null, instance, FieldDescriptor.parseDescriptor(cn.descriptor), bytecodeOffsets);
    }

    public FieldExprent(String name, String classname, boolean isStatic, Exprent instance, FieldDescriptor descriptor, BitSet bytecodeOffsets) {
        this(name, classname, isStatic, instance, descriptor, bytecodeOffsets, false, false);
    }

    public FieldExprent(String name, String classname, boolean isStatic, Exprent instance, FieldDescriptor descriptor, BitSet bytecodeOffsets, boolean forceQualified, boolean wasCondy) {
        super(Exprent.Type.FIELD);
        this.name = name;
        this.classname = classname;
        this.isStatic = isStatic;
        this.instance = instance;
        this.descriptor = descriptor;
        this.forceQualified = forceQualified;
        this.wasCondy = wasCondy;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public VarType getExprType() {
        return this.descriptor.type;
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        Map<Object, Object> types = cl == null ? Collections.emptyMap() : cl.getAllGenerics();
        StructField ft = null;
        while (cl != null && (ft = cl.getField(this.name, this.descriptor.descriptorString)) == null) {
            cl = cl.superClass == null ? null : DecompilerContext.getStructContext().getClass((String)cl.superClass.value);
        }
        if (ft != null && ft.getSignature() != null) {
            VarType instType;
            VarType ret = ft.getSignature().type.remap(types.getOrDefault(cl.qualifiedName, Collections.emptyMap()));
            if (this.instance != null && cl.getSignature() != null && (instType = this.instance.getInferredExprType(null)).isGeneric() && instType.type != CodeType.GENVAR) {
                GenericType ginstance = (GenericType)instType;
                cl = DecompilerContext.getStructContext().getClass(instType.value);
                if (cl != null && cl.getSignature() != null) {
                    HashMap<VarType, VarType> tempMap = new HashMap<VarType, VarType>();
                    cl.getSignature().genericType.mapGenVarsTo(ginstance, tempMap);
                    VarType _new = ret.remap(tempMap);
                    ret = _new != null ? _new : this.getExprType();
                }
            }
            return ret;
        }
        return this.getExprType();
    }

    @Override
    public int getExprentUse() {
        return this.instance == null ? 1 : this.instance.getExprentUse() & 1;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        if (this.instance != null) {
            lst.add(this.instance);
        }
        return lst;
    }

    @Override
    public Exprent copy() {
        return new FieldExprent(this.name, this.classname, this.isStatic, this.instance == null ? null : this.instance.copy(), this.descriptor, this.bytecode, this.forceQualified, this.wasCondy);
    }

    private boolean isAmbiguous() {
        StructLocalVariableTableAttribute attr;
        MethodWrapper method = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_METHOD_WRAPPER);
        if (method != null && (attr = method.methodStruct.getLocalVariableAttr()) != null) {
            return attr.containsName(this.name);
        }
        return false;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = new TextBuffer();
        if (this.wasCondy) {
            buf.append("/* $VF: constant dynamic */ ");
        }
        if (this.isStatic) {
            if (this.name.equals("TYPE") && ExprUtil.PRIMITIVE_TYPES.containsKey(this.classname)) {
                buf.append(ExprUtil.PRIMITIVE_TYPES.get(this.classname));
                buf.append(".class");
                return buf;
            }
            if (this.useQualifiedStatic()) {
                buf.appendAllClasses(DecompilerContext.getImportCollector().getShortNameInClassContext(ExprProcessor.buildJavaClassName(this.classname)), this.classname);
                buf.append(".");
            }
        } else {
            String super_qualifier = null;
            if (this.instance instanceof VarExprent) {
                String this_classname;
                VarExprent instVar = (VarExprent)this.instance;
                VarVersionPair pair = new VarVersionPair(instVar);
                MethodWrapper currentMethod = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_METHOD_WRAPPER);
                if (currentMethod != null && (this_classname = currentMethod.varproc.getThisVars().get(pair)) != null && !this.classname.equals(this_classname)) {
                    super_qualifier = this_classname;
                }
            }
            if (super_qualifier != null) {
                TextUtil.writeQualifiedSuper(buf, super_qualifier);
            } else {
                TextBuffer buff;
                boolean casted;
                if (!this.isQualifier) {
                    buf.pushNewlineGroup(indent, 1);
                }
                if (this.instance != null) {
                    this.instance.setIsQualifier();
                }
                if ((casted = ExprProcessor.getCastedExprent(this.instance, new VarType(CodeType.OBJECT, 0, this.classname), buff = new TextBuffer(), indent, true)) || this.instance.getPrecedence() > this.getPrecedence()) {
                    buff.encloseWithParens();
                }
                buf.append(buff);
                if (this.instance != null && this.instance.allowNewlineAfterQualifier()) {
                    buf.appendPossibleNewline();
                }
                if (!this.isQualifier) {
                    buf.popNewlineGroup();
                }
            }
            if (buf.contentEquals("<VAR_NAMELESS_ENCLOSURE>")) {
                buf.setLength(0);
            } else {
                buf.append(".");
            }
        }
        buf.addBytecodeMapping(this.bytecode);
        buf.appendField(this.name, false, this.classname, this.name, this.descriptor);
        return buf;
    }

    private boolean useQualifiedStatic() {
        ClassesProcessor.ClassNode node = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE);
        return node == null || !this.classname.equals(node.classStruct.qualifiedName) || this.isAmbiguous() || this.forceQualified;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.instance) {
            this.instance = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldExprent)) {
            return false;
        }
        FieldExprent ft = (FieldExprent)o;
        return InterpreterUtil.equalObjects(this.name, ft.getName()) && InterpreterUtil.equalObjects(this.classname, ft.getClassname()) && this.isStatic == ft.isStatic() && InterpreterUtil.equalObjects(this.instance, ft.getInstance()) && InterpreterUtil.equalObjects(this.descriptor, ft.getDescriptor());
    }

    public String getClassname() {
        return this.classname;
    }

    public FieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Exprent getInstance() {
        return this.instance;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getName() {
        return this.name;
    }

    public void forceQualified(boolean value) {
        this.forceQualified = value;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        FieldExprent.measureBytecode(values, this.instance);
        this.measureBytecode(values);
    }

    @Override
    public void setIsQualifier() {
        this.isQualifier = true;
    }

    @Override
    public boolean allowNewlineAfterQualifier() {
        if (this.isStatic && !this.useQualifiedStatic()) {
            return false;
        }
        return super.allowNewlineAfterQualifier();
    }

    @Override
    public void processSforms(SFormsConstructor sFormsConstructor, VarMapHolder varMaps, Statement stat, boolean calcLiveVars) {
        if (this.instance != null) {
            this.instance.processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
        }
        sFormsConstructor.fieldRead(this, varMaps.getNormal());
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        MatchNode.RuleValue rule = matchNode.getRawRule(IMatchable.MatchProperties.EXPRENT_NAME);
        if (rule != null) {
            if (rule.isVariable()) {
                return engine.checkAndSetVariableValue((String)rule.value, this.name);
            }
            return rule.value.equals(this.name);
        }
        return true;
    }
}

