/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.vineflower.java.decompiler.main.ClassesProcessor;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.collectors.ImportCollector;
import org.vineflower.java.decompiler.main.rels.MethodWrapper;
import org.vineflower.java.decompiler.modules.decompiler.ExprProcessor;
import org.vineflower.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.VarExprent;
import org.vineflower.java.decompiler.modules.decompiler.sforms.SFormsConstructor;
import org.vineflower.java.decompiler.modules.decompiler.sforms.VarMapHolder;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.vineflower.java.decompiler.struct.StructField;
import org.vineflower.java.decompiler.struct.StructMethod;
import org.vineflower.java.decompiler.struct.gen.VarType;
import org.vineflower.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.vineflower.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.vineflower.java.decompiler.struct.gen.generics.GenericType;
import org.vineflower.java.decompiler.util.InterpreterUtil;
import org.vineflower.java.decompiler.util.TextBuffer;
import org.vineflower.java.decompiler.util.collections.SFormsFastMapDirect;

public class AssignmentExprent
extends Exprent {
    private Exprent left;
    private Exprent right;
    private FunctionExprent.FunctionType condType = null;

    public AssignmentExprent(Exprent left, Exprent right, BitSet bytecodeOffsets) {
        super(Exprent.Type.ASSIGNMENT);
        this.left = left;
        this.right = right;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    public AssignmentExprent(Exprent left, Exprent right, FunctionExprent.FunctionType condType, BitSet bytecodeOffsets) {
        this(left, right, bytecodeOffsets);
        this.condType = condType;
    }

    @Override
    public VarType getExprType() {
        VarType rType = VarType.getCommonSupertype(this.left.getExprType(), this.right.getExprType());
        return rType == null ? this.left.getExprType() : rType;
    }

    @Override
    public VarType getInferredExprType(VarType upperBounds) {
        return this.left.getInferredExprType(upperBounds);
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        VarType typeLeft = this.left.getExprType();
        VarType typeRight = this.right.getExprType();
        if (typeLeft.typeFamily.isGreater(typeRight.typeFamily)) {
            result.addMinTypeExprent(this.right, VarType.getMinTypeInFamily(typeLeft.typeFamily));
        } else if (typeLeft.typeFamily.isLesser(typeRight.typeFamily)) {
            result.addMinTypeExprent(this.left, typeRight);
        } else {
            result.addMinTypeExprent(this.left, VarType.getCommonSupertype(typeLeft, typeRight));
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        lst.add(this.left);
        lst.add(this.right);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new AssignmentExprent(this.left.copy(), this.right.copy(), this.condType, this.bytecode);
    }

    @Override
    public int getPrecedence() {
        return 13;
    }

    @Override
    public TextBuffer toJava(int indent) {
        VarExprent varLeft;
        VarType leftType = this.left.getInferredExprType(null);
        boolean fieldInClassInit = false;
        boolean hiddenField = false;
        if (this.left instanceof FieldExprent) {
            StructField fd;
            FieldExprent field = (FieldExprent)this.left;
            ClassesProcessor.ClassNode node = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE);
            if (node != null && (fd = node.classStruct.getField(field.getName(), field.getDescriptor().descriptorString)) != null) {
                if (field.isStatic() && fd.hasModifier(16)) {
                    fieldInClassInit = true;
                }
                if (node.getWrapper() != null && node.getWrapper().getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()))) {
                    hiddenField = true;
                }
            }
        }
        if (hiddenField) {
            return new TextBuffer();
        }
        TextBuffer buffer = new TextBuffer();
        if (fieldInClassInit) {
            FieldExprent field = (FieldExprent)this.left;
            buffer.appendField(field.getName(), false, field.getClassname(), field.getName(), field.getDescriptor());
        } else {
            buffer.append(this.left.toJava(indent));
        }
        if (this.right instanceof ConstExprent) {
            ((ConstExprent)this.right).adjustConstType(leftType);
        }
        this.optimizeCastForAssign();
        if (this.condType == null) {
            String castName;
            buffer.append(" = ");
            try (ImportCollector.Lock lock = DecompilerContext.getImportCollector().lock();){
                castName = ExprProcessor.getCastTypeName(leftType);
            }
            if (castName.equals("<unrepresentable>")) {
                buffer.append(this.right.toJava(indent));
            } else {
                ExprProcessor.getCastedExprent(this.right, leftType, buffer, indent, ExprProcessor.NullCastType.DONT_CAST_AT_ALL, false, false, false);
            }
        } else {
            buffer.append(" ").append(this.condType.operator).append("= ");
            buffer.append(this.right.toJava(indent));
        }
        buffer.addStartBytecodeMapping(this.bytecode);
        if (this.left instanceof VarExprent && DecompilerContext.getOption("decompiler-comments") && (varLeft = (VarExprent)this.left).isDefinition() && varLeft.getProcessor() != null && varLeft.getProcessor().getSyntheticSemaphores().contains(varLeft.getIndex())) {
            buffer.append(" /* VF: Semaphore variable */");
        }
        return buffer;
    }

    private void optimizeCastForAssign() {
        VarType leftType;
        if (!(this.right instanceof FunctionExprent)) {
            return;
        }
        FunctionExprent func = (FunctionExprent)this.right;
        if (func.getFuncType() != FunctionExprent.FunctionType.CAST) {
            return;
        }
        Exprent cast = func.getLstOperands().get(1);
        if (!func.doesCast() && this.left instanceof VarExprent && DecompilerContext.getStructContext().instanceOf(this.right.getExprType().value, cast.getExprType().value)) {
            Exprent castVal = func.getLstOperands().get(0);
            if (this.left.getExprType().arrayDim > castVal.getExprType().arrayDim) {
                func.setNeedsCast(true);
                return;
            }
        }
        if (!((leftType = this.left.getInferredExprType(null)) instanceof GenericType)) {
            return;
        }
        MethodWrapper method = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_METHOD_WRAPPER);
        if (method == null) {
            return;
        }
        StructMethod mt = method.methodStruct;
        GenericMethodDescriptor descriptor = mt.getSignature();
        if (descriptor == null || descriptor.typeParameters.isEmpty()) {
            return;
        }
        List<String> params = descriptor.typeParameters;
        int index = params.indexOf(leftType.value);
        if (index == -1) {
            return;
        }
        List<List<VarType>> bounds = descriptor.typeParameterBounds;
        List<VarType> types = bounds.get(index);
        GenericClassDescriptor classDescriptor = method.classStruct.getSignature();
        if (classDescriptor != null) {
            for (VarType type : new ArrayList<VarType>(types)) {
                int idex = classDescriptor.fparameters.indexOf(type.value);
                if (idex == -1) continue;
                types.addAll((Collection<VarType>)classDescriptor.fbounds.get(idex));
            }
        }
        VarType rightType = cast.getInferredExprType(leftType);
        boolean didReset = false;
        for (VarType type : types) {
            if (!rightType.value.equals(type.value)) continue;
            ((ConstExprent)cast).setConstType(leftType);
            didReset = true;
        }
        if (didReset) {
            func.getInferredExprType(null);
        }
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.left) {
            this.left = newExpr;
        }
        if (oldExpr == this.right) {
            this.right = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssignmentExprent)) {
            return false;
        }
        AssignmentExprent as = (AssignmentExprent)o;
        return InterpreterUtil.equalObjects(this.left, as.getLeft()) && InterpreterUtil.equalObjects(this.right, as.getRight()) && this.condType == as.getCondType();
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        AssignmentExprent.measureBytecode(values, this.left);
        AssignmentExprent.measureBytecode(values, this.right);
        this.measureBytecode(values);
    }

    @Override
    public void processSforms(SFormsConstructor sFormsConstructor, VarMapHolder varMaps, Statement stat, boolean calcLiveVars) {
        Exprent dest = this.left;
        switch (dest.type) {
            case VAR: {
                VarExprent destVar = (VarExprent)dest;
                if (this.condType != null) {
                    destVar.processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                    this.getRight().processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                    SFormsFastMapDirect varMap = varMaps.toNormal();
                    varMap.setCurrentVar(sFormsConstructor.getOrCreatePhantom(destVar.getVarVersionPair()));
                } else {
                    this.getRight().processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                    sFormsConstructor.updateVarExprent(destVar, stat, varMaps.toNormal(), calcLiveVars);
                    if (sFormsConstructor.trackDirectAssignments) {
                        switch (this.right.type) {
                            case VAR: {
                                VarVersionPair rightpaar = ((VarExprent)this.right).getVarVersionPair();
                                sFormsConstructor.markDirectAssignment(destVar.getVarVersionPair(), rightpaar);
                                break;
                            }
                            case FIELD: {
                                int index = sFormsConstructor.getFieldIndex((FieldExprent)this.right);
                                VarVersionPair rightpaar = new VarVersionPair(index, 0);
                                sFormsConstructor.markDirectAssignment(destVar.getVarVersionPair(), rightpaar);
                                break;
                            }
                        }
                    }
                }
                return;
            }
            case FIELD: {
                this.getLeft().processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                varMaps.assertIsNormal();
                this.getRight().processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
                varMaps.toNormal();
                varMaps.getNormal().removeAllFields();
                return;
            }
        }
        this.getLeft().processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
        varMaps.assertIsNormal();
        this.getRight().processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
        varMaps.toNormal();
    }

    public Exprent getLeft() {
        return this.left;
    }

    public Exprent getRight() {
        return this.right;
    }

    public void setRight(Exprent right) {
        this.right = right;
    }

    public FunctionExprent.FunctionType getCondType() {
        return this.condType;
    }

    public void setCondType(FunctionExprent.FunctionType condType) {
        this.condType = condType;
    }
}

