/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler.decompose;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.vineflower.java.decompiler.modules.decompiler.StatEdge;
import org.vineflower.java.decompiler.modules.decompiler.decompose.DominatorEngine;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.util.collections.fixed.FastFixedSet;

public final class SupportComponent {
    public final List<Statement> stats;
    public final Map<Integer, FastFixedSet<Integer>> selfSupportPoints;
    public final Statement supportedPoint;

    public SupportComponent(List<Statement> stats, Map<Integer, FastFixedSet<Integer>> selfSupportPoints, Statement supportedPoint) {
        this.stats = stats;
        this.selfSupportPoints = selfSupportPoints;
        this.supportedPoint = supportedPoint;
    }

    public static SupportComponent identify(List<Statement> component, Map<Integer, FastFixedSet<Integer>> mapSupportPoints, DominatorEngine dom) {
        HashMap<Integer, FastFixedSet<Integer>> selfSupportPoints = new HashMap<Integer, FastFixedSet<Integer>>();
        HashSet<Statement> supportedAll = new HashSet<Statement>();
        for (Statement statement : component) {
            FastFixedSet<Integer> supReach = mapSupportPoints.get(statement.id);
            if (supReach == null) continue;
            for (StatEdge edge : statement.getSuccessorEdgeView(1)) {
                Statement dest = edge.getDestination();
                if (!component.contains(dest)) {
                    return null;
                }
                if (!dom.isDominator(statement.id, dest.id)) continue;
                supportedAll.add(dest);
            }
            selfSupportPoints.put(statement.id, supReach);
        }
        if (supportedAll.size() != 1) {
            return null;
        }
        if (selfSupportPoints.isEmpty()) {
            return null;
        }
        ArrayList<Statement> outgoing = new ArrayList<Statement>();
        for (Statement st : component) {
            for (StatEdge edge : st.getPredecessorEdges(1)) {
                if (component.contains(edge.getSource())) continue;
                outgoing.add(st);
            }
        }
        if (outgoing.size() != 1) {
            return null;
        }
        Statement statement = (Statement)outgoing.get(0);
        for (Statement st : component) {
            if (dom.isDominator(st.id, statement.id)) continue;
            return null;
        }
        return new SupportComponent(component, selfSupportPoints, statement);
    }

    public String toString() {
        return "SupportComponent[" + String.valueOf(this.stats) + ", selfSupportPoints=" + String.valueOf(this.selfSupportPoints) + ", header=" + String.valueOf(this.supportedPoint) + "]";
    }
}

