/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler.decompose;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.util.collections.ListStack;

public final class StrongConnectivityHelper {
    private final List<List<Statement>> components = new ArrayList<List<Statement>>();
    private final Set<Statement> processed = new HashSet<Statement>();
    private final ListStack<Statement> stack = new ListStack();
    private final Set<Statement> visitedStatements = new HashSet<Statement>();
    private final Map<Statement, Integer> indexMap = new HashMap<Statement, Integer>();
    private final Map<Statement, Integer> lowLinkMap = new HashMap<Statement, Integer>();
    private final Map<Statement, Boolean> onStack = new HashMap<Statement, Boolean>();
    private int index;

    public StrongConnectivityHelper(Statement stat) {
        this.visitTree(stat.getFirst());
        for (Statement st : stat.getStats()) {
            if (this.processed.contains(st) || !st.getPredecessorEdges(0x40000000).isEmpty()) continue;
            this.visitTree(st);
        }
        for (Statement st : stat.getStats()) {
            if (this.processed.contains(st)) continue;
            this.visitTree(st);
        }
    }

    private void visitTree(Statement stat) {
        this.stack.clear();
        this.index = 0;
        this.visitedStatements.clear();
        this.indexMap.clear();
        this.lowLinkMap.clear();
        this.onStack.clear();
        this.visit(stat);
        this.processed.addAll(this.visitedStatements);
        this.processed.add(stat);
    }

    private void visit(Statement stat) {
        this.stack.push(stat);
        this.indexMap.put(stat, this.index);
        this.lowLinkMap.put(stat, this.index);
        ++this.index;
        this.onStack.put(stat, true);
        List<Statement> successors = stat.getNeighbours(1, Statement.EdgeDirection.FORWARD);
        successors.removeAll(this.processed);
        for (Statement succ : successors) {
            int newValue;
            if (this.visitedStatements.contains(succ)) {
                if (!this.onStack.get(succ).booleanValue()) continue;
                newValue = this.indexMap.get(succ);
            } else {
                this.visitedStatements.add(succ);
                this.visit(succ);
                newValue = this.lowLinkMap.get(succ);
            }
            this.lowLinkMap.put(stat, Math.min(this.lowLinkMap.get(stat), newValue));
        }
        if (this.lowLinkMap.get(stat).intValue() == this.indexMap.get(stat).intValue()) {
            Statement v;
            ArrayList<Statement> component = new ArrayList<Statement>();
            do {
                v = this.stack.pop();
                this.onStack.put(v, false);
                component.add(v);
            } while (v != stat);
            this.components.add(component);
        }
    }

    public static boolean isExitComponent(List<? extends Statement> lst) {
        HashSet<Statement> set = new HashSet<Statement>();
        for (Statement statement : lst) {
            set.addAll(statement.getNeighbours(1, Statement.EdgeDirection.FORWARD));
        }
        for (Statement statement : lst) {
            set.remove(statement);
        }
        return set.isEmpty();
    }

    public static List<Statement> getExitReps(List<? extends List<Statement>> lst) {
        ArrayList<Statement> res = new ArrayList<Statement>();
        for (List<Statement> list : lst) {
            if (!StrongConnectivityHelper.isExitComponent(list)) continue;
            res.add(list.get(0));
        }
        return res;
    }

    public List<List<Statement>> getComponents() {
        return this.components;
    }
}

